/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.apache.commons.collections.map.ReferenceMap;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NonExtensible;
import org.gradle.api.Nullable;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.NoConventionMapping;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.PropertyDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Map<Class<?>, Map<Class<?>, Class<?>>> GENERATED_CLASSES = new HashMap();
    private static final Lock CACHE_LOCK = new ReentrantLock();
    private static final Collection<String> SKIP_PROPERTIES = Arrays.asList("class", "metaClass", "conventionMapping", "convention", "asDynamicObject", "extensions");

    public <T> T newInstance(Class<T> type, Object ... parameters) {
        return (T)DirectInstantiator.instantiate(this.generate(type), (Object[])parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> generate(Class<T> type) {
        try {
            CACHE_LOCK.lock();
            Class<T> clazz = this.generateUnderLock(type);
            return clazz;
        }
        finally {
            CACHE_LOCK.unlock();
        }
    }

    private <T> Class<? extends T> generateUnderLock(Class<T> type) {
        Class<T> subclass;
        Class<?> generatedClass;
        ReferenceMap cache = GENERATED_CLASSES.get(this.getClass());
        if (cache == null) {
            cache = new ReferenceMap(2, 2);
            GENERATED_CLASSES.put(this.getClass(), (Map<Class<?>, Class<?>>)cache);
        }
        if ((generatedClass = cache.get(type)) != null) {
            return generatedClass.asSubclass(type);
        }
        if (Modifier.isPrivate(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for private class '%s'.", type.getSimpleName()));
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new GradleException(String.format("Cannot create a proxy class for abstract class '%s'.", type.getSimpleName()));
        }
        try {
            ClassMetaData classMetaData = this.inspectType(type);
            ClassBuilder<T> builder = this.start(type, classMetaData);
            builder.startClass();
            if (!DynamicObjectAware.class.isAssignableFrom(type)) {
                if (ExtensionAware.class.isAssignableFrom(type)) {
                    throw new UnsupportedOperationException("A type that implements ExtensionAware must currently also implement DynamicObjectAware.");
                }
                builder.mixInDynamicAware();
            }
            if (!GroovyObject.class.isAssignableFrom(type)) {
                builder.mixInGroovyObject();
            }
            builder.addDynamicMethods();
            if (classMetaData.conventionAware && !IConventionAware.class.isAssignableFrom(type)) {
                builder.mixInConventionAware();
            }
            Class noMappingClass = Object.class;
            for (Class<T> c = type; c != null && noMappingClass == Object.class; c = c.getSuperclass()) {
                if (c.getAnnotation(NoConventionMapping.class) == null) continue;
                noMappingClass = c;
            }
            HashSet<PropertyMetaData> conventionProperties = new HashSet<PropertyMetaData>();
            for (PropertyMetaData property : classMetaData.properties.values()) {
                if (SKIP_PROPERTIES.contains(property.name)) continue;
                if (property.injector) {
                    builder.addInjectorProperty(property);
                    for (Method getter : property.getters) {
                        builder.applyServiceInjectionToGetter(property, getter);
                    }
                    for (Method setter : property.setters) {
                        builder.applyServiceInjectionToSetter(property, setter);
                    }
                    continue;
                }
                boolean needsConventionMapping = false;
                if (classMetaData.isExtensible()) {
                    for (Method getter : property.getters) {
                        if (Modifier.isFinal(getter.getModifiers()) || getter.getDeclaringClass().isAssignableFrom(noMappingClass)) continue;
                        needsConventionMapping = true;
                        break;
                    }
                }
                if (needsConventionMapping) {
                    conventionProperties.add(property);
                    builder.addConventionProperty(property);
                    for (Method getter : property.getters) {
                        builder.applyConventionMappingToGetter(property, getter);
                    }
                }
                if (!needsConventionMapping) continue;
                for (Method setter : property.setters) {
                    if (Modifier.isFinal(setter.getModifiers())) continue;
                    builder.applyConventionMappingToSetter(property, setter);
                }
            }
            Set actionMethods = classMetaData.missingOverloads;
            for (Method method : actionMethods) {
                builder.addActionMethod(method);
            }
            for (PropertyMetaData property : classMetaData.properties.values()) {
                if (property.setters.isEmpty() || Iterable.class.isAssignableFrom(property.getType())) continue;
                if (property.setMethods.isEmpty()) {
                    for (Method setter : property.setters) {
                        builder.addSetMethod(property, setter);
                    }
                    continue;
                }
                if (!conventionProperties.contains(property)) continue;
                for (Method setMethod : property.setMethods) {
                    builder.applyConventionMappingToSetMethod(property, setMethod);
                }
            }
            for (Constructor<?> constructor : type.getConstructors()) {
                if (!Modifier.isPublic(constructor.getModifiers())) continue;
                builder.addConstructor(constructor);
            }
            subclass = builder.generate();
        }
        catch (Throwable e) {
            throw new GradleException(String.format("Could not generate a proxy class for class %s.", type.getName()), e);
        }
        cache.put(type, subclass);
        cache.put(subclass, subclass);
        return subclass;
    }

    protected abstract <T> ClassBuilder<T> start(Class<T> var1, ClassMetaData var2);

    private ClassMetaData inspectType(Class<?> type) {
        boolean isConventionAware = type.getAnnotation(NoConventionMapping.class) == null;
        boolean extensible = JavaReflectionUtil.getAnnotation(type, NonExtensible.class) == null;
        ClassMetaData classMetaData = new ClassMetaData(extensible, isConventionAware);
        this.inspectType(type, classMetaData);
        this.attachSetMethods(classMetaData);
        this.findMissingClosureOverloads(classMetaData);
        classMetaData.complete();
        return classMetaData;
    }

    private void findMissingClosureOverloads(ClassMetaData classMetaData) {
        for (Method method : classMetaData.actionMethods) {
            Method overload = this.findClosureOverload(method, classMetaData.closureMethods.get((Object)method.getName()));
            if (overload != null) continue;
            classMetaData.actionMethodRequiresOverload(method);
        }
    }

    private Method findClosureOverload(Method method, Collection<Method> candidates) {
        for (Method candidate : candidates) {
            if (candidate.getParameterTypes().length != method.getParameterTypes().length) continue;
            boolean matches = true;
            for (int i = 0; matches && i < candidate.getParameterTypes().length - 1; ++i) {
                if (candidate.getParameterTypes()[i].equals(method.getParameterTypes()[i])) continue;
                matches = false;
            }
            if (!matches) continue;
            return candidate;
        }
        return null;
    }

    private void attachSetMethods(ClassMetaData classMetaData) {
        for (Method method : classMetaData.setMethods) {
            PropertyMetaData property = classMetaData.getProperty(method.getName());
            if (property == null) continue;
            property.addSetMethod(method);
        }
    }

    private void inspectType(Class<?> type, ClassMetaData classMetaData) {
        ClassDetails classDetails = ClassInspector.inspect(type);
        for (Method method : classDetails.getAllMethods()) {
            if (method.getAnnotation(Inject.class) == null) continue;
            if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers())) {
                throw new UnsupportedOperationException(String.format("Cannot attach @Inject to method %s.%s() as it is not public or protected.", method.getDeclaringClass().getSimpleName(), method.getName()));
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            throw new UnsupportedOperationException(String.format("Cannot attach @Inject to method %s.%s() as it is static.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        for (PropertyDetails property : classDetails.getProperties()) {
            PropertyMetaData propertyMetaData = classMetaData.property(property.getName());
            for (Method method : property.getGetters()) {
                propertyMetaData.addGetter(method);
            }
            for (Method method : property.getSetters()) {
                propertyMetaData.addSetter(method);
            }
        }
        for (Method method : classDetails.getInstanceMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                classMetaData.addCandidateSetMethod(method);
            }
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].equals(Action.class)) {
                classMetaData.addActionMethod(method);
                continue;
            }
            if (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].equals(Closure.class)) continue;
            classMetaData.addClosureMethod(method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ClassBuilder<T> {
        public void startClass();

        public void addConstructor(Constructor<?> var1) throws Exception;

        public void mixInDynamicAware() throws Exception;

        public void mixInConventionAware() throws Exception;

        public void mixInGroovyObject() throws Exception;

        public void addDynamicMethods() throws Exception;

        public void addInjectorProperty(PropertyMetaData var1);

        public void applyServiceInjectionToGetter(PropertyMetaData var1, Method var2) throws Exception;

        public void applyServiceInjectionToSetter(PropertyMetaData var1, Method var2) throws Exception;

        public void addConventionProperty(PropertyMetaData var1) throws Exception;

        public void applyConventionMappingToGetter(PropertyMetaData var1, Method var2) throws Exception;

        public void applyConventionMappingToSetter(PropertyMetaData var1, Method var2) throws Exception;

        public void applyConventionMappingToSetMethod(PropertyMetaData var1, Method var2) throws Exception;

        public void addSetMethod(PropertyMetaData var1, Method var2) throws Exception;

        public void addActionMethod(Method var1) throws Exception;

        public Class<? extends T> generate() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PropertyMetaData {
        final String name;
        final List<Method> getters = new ArrayList<Method>();
        final List<Method> setters = new ArrayList<Method>();
        final List<Method> setMethods = new ArrayList<Method>();
        boolean injector;

        private PropertyMetaData(String name) {
            this.name = name;
        }

        public String toString() {
            return String.format("[property %s]", this.name);
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            if (!this.getters.isEmpty()) {
                return this.getters.get(0).getReturnType();
            }
            return this.setters.get(0).getParameterTypes()[0];
        }

        public void addGetter(Method method) {
            if (this.getters.add(method) && method.getAnnotation(Inject.class) != null) {
                this.injector = true;
            }
        }

        public void addSetter(Method method) {
            this.setters.add(method);
        }

        public void addSetMethod(Method method) {
            this.setMethods.add(method);
        }
    }

    protected static class ClassMetaData {
        private final Map<String, PropertyMetaData> properties = new LinkedHashMap<String, PropertyMetaData>();
        private final Set<Method> missingOverloads = new LinkedHashSet<Method>();
        private final boolean extensible;
        private final boolean conventionAware;
        private List<Method> actionMethods = new ArrayList<Method>();
        private SetMultimap<String, Method> closureMethods = LinkedHashMultimap.create();
        private List<Method> setMethods = new ArrayList<Method>();

        public ClassMetaData(boolean extensible, boolean conventionAware) {
            this.extensible = extensible;
            this.conventionAware = conventionAware;
        }

        @Nullable
        public PropertyMetaData getProperty(String name) {
            return this.properties.get(name);
        }

        public PropertyMetaData property(String name) {
            PropertyMetaData property = this.properties.get(name);
            if (property == null) {
                property = new PropertyMetaData(name);
                this.properties.put(name, property);
            }
            return property;
        }

        public void addActionMethod(Method method) {
            this.actionMethods.add(method);
        }

        public void addClosureMethod(Method method) {
            this.closureMethods.put((Object)method.getName(), (Object)method);
        }

        public void addCandidateSetMethod(Method method) {
            this.setMethods.add(method);
        }

        public void complete() {
            this.setMethods = null;
            this.actionMethods = null;
            this.closureMethods = null;
        }

        public void actionMethodRequiresOverload(Method method) {
            this.missingOverloads.add(method);
        }

        public boolean providesDynamicObjectImplementation() {
            PropertyMetaData property = this.properties.get("asDynamicObject");
            return property != null && !property.getters.isEmpty();
        }

        public boolean isExtensible() {
            return this.extensible;
        }

        public boolean isConventionAware() {
            return this.conventionAware;
        }
    }
}

