/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.plugins.AbstractRule;
import org.gradle.api.tasks.TaskContainer;

public class BuildConfigurationRule
extends AbstractRule {
    public static final String PREFIX = "build";
    private final ConfigurationContainer configurations;
    private final TaskContainer tasks;

    public BuildConfigurationRule(ConfigurationContainer configurations, TaskContainer tasks) {
        this.configurations = configurations;
        this.tasks = tasks;
    }

    public String getDescription() {
        return String.format("Pattern: %s<ConfigurationName>: Assembles the artifacts of a configuration.", PREFIX);
    }

    public void apply(String taskName) {
        String configurationName;
        Configuration configuration;
        if (taskName.startsWith(PREFIX) && (configuration = (Configuration)this.configurations.findByName(configurationName = StringUtils.uncapitalize((String)taskName.substring(PREFIX.length())))) != null) {
            Task task = this.tasks.create(taskName);
            task.dependsOn(new Object[]{configuration.getAllArtifacts()});
            task.setDescription(String.format("Builds the artifacts belonging to %s.", configuration));
        }
    }
}

