/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.mortbay.jetty.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(Monitor.class);
    private String key;
    ServerSocket serverSocket;
    private final Server server;

    public Monitor(int port, String key, Server server) throws IOException {
        this.server = server;
        if (port <= 0) {
            throw new IllegalStateException("Bad stop port");
        }
        if (key == null) {
            throw new IllegalStateException("Bad stop key");
        }
        this.key = key;
        this.setDaemon(true);
        this.setName("StopJettyPluginMonitor");
        this.serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        this.serverSocket.setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.serverSocket != null) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                socket.setSoLinger(false, 0);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                String key = lin.readLine();
                if (!this.key.equals(key)) continue;
                String cmd = lin.readLine();
                if ("stop".equals(cmd)) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception when stopping server", (Throwable)e);
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception when stopping server", (Throwable)e);
                    }
                    try {
                        this.serverSocket.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception when stopping server", (Throwable)e);
                    }
                    this.serverSocket = null;
                    try {
                        LOGGER.info("Stopping server due to received '{}' command...", (Object)cmd);
                        this.server.stop();
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception when stopping server", (Throwable)e);
                    }
                    return;
                }
                LOGGER.info("Unsupported monitor operation");
            }
            catch (Exception e) {
                LOGGER.error("Exception during monitoring Server", (Throwable)e);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception when stopping server", (Throwable)e);
                    }
                }
                socket = null;
            }
        }
    }
}

