/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import org.apache.tools.ant.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypedNotationConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishArtifactNotationParserFactory
implements Factory<NotationParser<Object, PublishArtifact>> {
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider metaDataProvider;

    public PublishArtifactNotationParserFactory(Instantiator instantiator, DependencyMetaDataProvider metaDataProvider) {
        this.instantiator = instantiator;
        this.metaDataProvider = metaDataProvider;
    }

    public NotationParser<Object, PublishArtifact> create() {
        FileNotationConverter fileConverter = new FileNotationConverter();
        return NotationParserBuilder.toType(PublishArtifact.class).converter((NotationConverter)new ArchiveTaskNotationConverter()).converter((NotationConverter)new FileMapNotationConverter(fileConverter)).converter((NotationConverter)fileConverter).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNotationConverter
    extends TypedNotationConverter<File, PublishArtifact> {
        private FileNotationConverter() {
            super(File.class);
        }

        protected PublishArtifact parseType(File file) {
            ModuleInternal module = PublishArtifactNotationParserFactory.this.metaDataProvider.getModule();
            ArtifactFile artifactFile = new ArtifactFile(file, module.getVersion());
            return (PublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(DefaultPublishArtifact.class, new Object[]{artifactFile.getName(), artifactFile.getExtension(), artifactFile.getExtension() == null ? "" : artifactFile.getExtension(), artifactFile.getClassifier(), null, file, new Task[0]});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileMapNotationConverter
    extends MapNotationConverter<PublishArtifact> {
        private final FileNotationConverter fileConverter;

        private FileMapNotationConverter(FileNotationConverter fileConverter) {
            this.fileConverter = fileConverter;
        }

        protected PublishArtifact parseMap(@MapKey(value="file") File file) {
            return this.fileConverter.parseType(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArchiveTaskNotationConverter
    extends TypedNotationConverter<AbstractArchiveTask, PublishArtifact> {
        private ArchiveTaskNotationConverter() {
            super(AbstractArchiveTask.class);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar.");
        }

        protected PublishArtifact parseType(AbstractArchiveTask notation) {
            return (PublishArtifact)PublishArtifactNotationParserFactory.this.instantiator.newInstance(ArchivePublishArtifact.class, new Object[]{notation});
        }
    }
}

