/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.LineBreakpoint;
import com.oracle.truffle.api.debug.LineToProbesMap;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EvalInstrumentListener;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultStandardInstrumentListener;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class LineBreakpointFactory {
    private static final boolean TRACE = false;
    private static final PrintStream OUT = System.out;
    private static final String BREAKPOINT_NAME = "Line Breakpoints";
    private static final Comparator<Map.Entry<LineLocation, LineBreakpointImpl>> BREAKPOINT_COMPARATOR = new Comparator<Map.Entry<LineLocation, LineBreakpointImpl>>(){

        @Override
        public int compare(Map.Entry<LineLocation, LineBreakpointImpl> entry1, Map.Entry<LineLocation, LineBreakpointImpl> entry2) {
            LineLocation line1 = entry1.getKey();
            LineLocation line2 = entry2.getKey();
            int nameOrder = line1.getSource().getShortName().compareTo(line2.getSource().getShortName());
            if (nameOrder != 0) {
                return nameOrder;
            }
            return Integer.compare(line1.getLineNumber(), line2.getLineNumber());
        }
    };
    private final Debugger debugger;
    private final Debugger.BreakpointCallback breakpointCallback;
    private final Debugger.WarningLog warningLog;
    private final Map<LineLocation, LineBreakpointImpl> lineToBreakpoint = new HashMap<LineLocation, LineBreakpointImpl>();
    private final LineToProbesMap lineToProbesMap;
    @CompilerDirectives.CompilationFinal
    private boolean breakpointsActive = true;
    private final CyclicAssumption breakpointsActiveUnchanged = new CyclicAssumption("Line Breakpoints globally active");

    @CompilerDirectives.TruffleBoundary
    private static void trace(String format, Object ... args) {
    }

    LineBreakpointFactory(Debugger debugger, Debugger.BreakpointCallback breakpointCallback, Debugger.WarningLog warningLog) {
        this.debugger = debugger;
        this.breakpointCallback = breakpointCallback;
        this.warningLog = warningLog;
        Instrumenter instrumenter = debugger.getInstrumenter();
        this.lineToProbesMap = new LineToProbesMap();
        instrumenter.install(this.lineToProbesMap);
        instrumenter.addProbeListener(new DefaultProbeListener(){

            @Override
            public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
                LineBreakpointImpl breakpoint;
                LineLocation lineLocation;
                SourceSection sourceSection;
                if (tag == StandardSyntaxTag.STATEMENT && (sourceSection = probe.getProbedSourceSection()) != null && (lineLocation = sourceSection.getLineLocation()) != null && (breakpoint = (LineBreakpointImpl)LineBreakpointFactory.this.lineToBreakpoint.get(lineLocation)) != null) {
                    breakpoint.attach(probe);
                }
            }
        });
    }

    void setActive(boolean breakpointsActive) {
        if (this.breakpointsActive != breakpointsActive) {
            this.breakpointsActiveUnchanged.invalidate();
            this.breakpointsActive = breakpointsActive;
        }
    }

    List<LineBreakpoint> getAll() {
        ArrayList<Map.Entry<LineLocation, LineBreakpointImpl>> entries = new ArrayList<Map.Entry<LineLocation, LineBreakpointImpl>>(this.lineToBreakpoint.entrySet());
        Collections.sort(entries, BREAKPOINT_COMPARATOR);
        ArrayList<LineBreakpoint> breakpoints = new ArrayList<LineBreakpoint>(entries.size());
        for (Map.Entry<LineLocation, LineBreakpointImpl> entry : entries) {
            breakpoints.add(entry.getValue());
        }
        return breakpoints;
    }

    LineBreakpoint create(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        LineBreakpointImpl breakpoint = this.lineToBreakpoint.get(lineLocation);
        if (breakpoint == null) {
            breakpoint = new LineBreakpointImpl(ignoreCount, lineLocation, oneShot);
            this.lineToBreakpoint.put(lineLocation, breakpoint);
            for (Probe probe : this.lineToProbesMap.findProbes(lineLocation)) {
                if (!probe.isTaggedAs(StandardSyntaxTag.STATEMENT)) continue;
                breakpoint.attach(probe);
                break;
            }
        } else {
            if (ignoreCount == breakpoint.getIgnoreCount()) {
                throw new IOException("Line Breakpoints already set at line " + lineLocation);
            }
            breakpoint.setIgnoreCount(ignoreCount);
        }
        return breakpoint;
    }

    LineBreakpoint get(LineLocation lineLocation) {
        return this.lineToBreakpoint.get(lineLocation);
    }

    void disposeOneShots() {
        ArrayList<LineBreakpointImpl> breakpoints = new ArrayList<LineBreakpointImpl>(this.lineToBreakpoint.values());
        for (LineBreakpointImpl breakpoint : breakpoints) {
            if (!breakpoint.isOneShot()) continue;
            breakpoint.dispose();
        }
    }

    private void forget(LineBreakpointImpl breakpoint) {
        this.lineToBreakpoint.remove(breakpoint.getLineLocation());
    }

    private final class LineBreakpointImpl
    extends LineBreakpoint
    implements EvalInstrumentListener {
        private static final String SHOULD_NOT_HAPPEN = "LineBreakpointImpl:  should not happen";
        private final LineLocation lineLocation;
        private Assumption breakpointsActiveAssumption;
        @CompilerDirectives.CompilationFinal
        private boolean isEnabled;
        private Assumption enabledUnchangedAssumption;
        private Source conditionSource;
        private List<ProbeInstrument> instruments;

        public LineBreakpointImpl(int ignoreCount, LineLocation lineLocation, boolean oneShot) {
            super(Breakpoint.State.ENABLED_UNRESOLVED, ignoreCount, oneShot);
            this.instruments = new ArrayList<ProbeInstrument>();
            this.lineLocation = lineLocation;
            this.breakpointsActiveAssumption = LineBreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            this.isEnabled = true;
            this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("Line Breakpoints enabled state unchanged");
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled != this.isEnabled) {
                switch (this.getState()) {
                    case ENABLED: {
                        assert (!enabled) : "LineBreakpointImpl:  should not happen";
                        this.doSetEnabled(false);
                        this.changeState(Breakpoint.State.DISABLED);
                        break;
                    }
                    case ENABLED_UNRESOLVED: {
                        assert (!enabled) : "LineBreakpointImpl:  should not happen";
                        this.doSetEnabled(false);
                        this.changeState(Breakpoint.State.DISABLED_UNRESOLVED);
                        break;
                    }
                    case DISABLED: {
                        assert (enabled) : "LineBreakpointImpl:  should not happen";
                        this.doSetEnabled(true);
                        this.changeState(Breakpoint.State.ENABLED);
                        break;
                    }
                    case DISABLED_UNRESOLVED: {
                        assert (enabled) : "LineBreakpointImpl:  should not happen";
                        this.doSetEnabled(true);
                        this.changeState(Breakpoint.State.DISABLED_UNRESOLVED);
                        break;
                    }
                    case DISPOSED: {
                        assert (false) : "breakpoint disposed";
                        break;
                    }
                    default: {
                        assert (false) : "LineBreakpointImpl:  should not happen";
                        break;
                    }
                }
            }
        }

        @Override
        public void setCondition(String expr) throws IOException {
            if (this.conditionSource != null || expr != null) {
                ArrayList<Probe> probes = new ArrayList<Probe>();
                for (ProbeInstrument instrument : this.instruments) {
                    probes.add(instrument.getProbe());
                    instrument.dispose();
                }
                this.instruments.clear();
                this.conditionSource = Source.fromText(expr, "breakpoint condition from text: " + expr);
                for (Probe probe : probes) {
                    this.attach(probe);
                }
            }
        }

        @Override
        public Source getCondition() {
            return this.conditionSource;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void dispose() {
            if (this.getState() != Breakpoint.State.DISPOSED) {
                for (ProbeInstrument instrument : this.instruments) {
                    instrument.dispose();
                }
                this.changeState(Breakpoint.State.DISPOSED);
                LineBreakpointFactory.this.forget(this);
            }
        }

        private void attach(Probe newProbe) {
            if (this.getState() == Breakpoint.State.DISPOSED) {
                throw new IllegalStateException("Attempt to attach a disposed Line Breakpoints");
            }
            ProbeInstrument newInstrument = null;
            Instrumenter instrumenter = LineBreakpointFactory.this.debugger.getInstrumenter();
            newInstrument = this.conditionSource == null ? instrumenter.attach(newProbe, new UnconditionalLineBreakInstrumentListener(), LineBreakpointFactory.BREAKPOINT_NAME) : instrumenter.attach(newProbe, this.conditionSource, this, LineBreakpointFactory.BREAKPOINT_NAME, null);
            this.instruments.add(newInstrument);
            this.changeState(this.isEnabled ? Breakpoint.State.ENABLED : Breakpoint.State.DISABLED);
        }

        private void doSetEnabled(boolean enabled) {
            if (this.isEnabled != enabled) {
                this.enabledUnchangedAssumption.invalidate();
                this.isEnabled = enabled;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private String getShortDescription() {
            return "Line Breakpoints@" + this.getLineLocation().getShortDescription();
        }

        private void changeState(Breakpoint.State after) {
            this.setState(after);
        }

        private void doBreak(Node node, VirtualFrame vFrame) {
            if (this.incrHitCountCheckIgnore()) {
                LineBreakpointFactory.this.breakpointCallback.haltedAt(node, vFrame.materialize(), LineBreakpointFactory.BREAKPOINT_NAME);
            }
        }

        private void nodeEnter(Node astNode, VirtualFrame vFrame) {
            try {
                this.breakpointsActiveAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.breakpointsActiveAssumption = LineBreakpointFactory.this.breakpointsActiveUnchanged.getAssumption();
            }
            try {
                this.enabledUnchangedAssumption.check();
            }
            catch (InvalidAssumptionException ex) {
                this.enabledUnchangedAssumption = Truffle.getRuntime().createAssumption("LineBreakpoint enabled state unchanged");
            }
            if (LineBreakpointFactory.this.breakpointsActive && this.isEnabled) {
                if (this.isOneShot()) {
                    this.dispose();
                }
                this.doBreak(astNode, vFrame);
            }
        }

        @Override
        public void onExecution(Node node, VirtualFrame vFrame, Object result) {
            if (result instanceof Boolean) {
                boolean condition = (Boolean)result;
                if (condition) {
                    this.nodeEnter(node, vFrame);
                }
            } else {
                this.onFailure(node, vFrame, new RuntimeException("breakpint failure = non-boolean condition " + result.toString()));
            }
        }

        @Override
        public void onFailure(Node node, VirtualFrame vFrame, Exception ex) {
            this.addExceptionWarning(ex);
            this.nodeEnter(node, vFrame);
        }

        @CompilerDirectives.TruffleBoundary
        private void addExceptionWarning(Exception ex) {
            LineBreakpointFactory.this.warningLog.addWarning(String.format("Exception in %s:  %s", this.getShortDescription(), ex.getMessage()));
        }

        @Override
        public String getLocationDescription() {
            return "Line: " + this.lineLocation.getShortDescription();
        }

        @Override
        public LineLocation getLineLocation() {
            return this.lineLocation;
        }

        private final class UnconditionalLineBreakInstrumentListener
        extends DefaultStandardInstrumentListener {
            private UnconditionalLineBreakInstrumentListener() {
            }

            @Override
            public void onEnter(Probe probe, Node node, VirtualFrame vFrame) {
                LineBreakpointImpl.this.nodeEnter(node, vFrame);
            }
        }
    }
}

