// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var Config, E, SC, Session, WordArray, constants, createHmac, env, iced, k, log, make_esc, make_scrypt_progress_hook, prompt_email_or_username, prompt_passphrase, req, triplesec, __iced_k, __iced_k_noop, _fn, _ref, _session,
    __slice = [].slice;

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  env = require('./env').env;

  req = require('./req');

  E = require('./err').E;

  make_esc = require('iced-error').make_esc;

  Config = require('./config').Config;

  _ref = require('./prompter'), prompt_passphrase = _ref.prompt_passphrase, prompt_email_or_username = _ref.prompt_email_or_username;

  constants = require('./constants').constants;

  SC = constants.security;

  triplesec = require('triplesec');

  WordArray = triplesec.WordArray;

  createHmac = require('crypto').createHmac;

  make_scrypt_progress_hook = require('./util').make_scrypt_progress_hook;

  log = require('./log');

  exports.Session = Session = (function() {
    Session.prototype.get_passphrase = function(_arg, cb) {
      var err, extra, pp, stderr, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      extra = _arg.extra, stderr = _arg.stderr;
      (function(_this) {
        return (function(__iced_k) {
          if (_this._passphrase == null) {
            err = null;
            pp = env().get_passphrase();
            (function(__iced_k) {
              if (pp == null) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/session.iced",
                    funcname: "Session.get_passphrase"
                  });
                  prompt_passphrase({
                    extra: extra,
                    short: true,
                    stderr: stderr
                  }, __iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        err = arguments[0];
                        return pp = arguments[1];
                      };
                    })(),
                    lineno: 26
                  }));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              return __iced_k(_this._passphrase = pp);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, _this._passphrase);
        };
      })(this));
    };

    Session.prototype.clear_passphrase = function() {
      return this._passphrase = null;
    };

    Session.prototype.get_email_or_username_i = function(cb) {
      var c, email, err, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      username = env().get_username();
      email = env().get_email();
      (function(_this) {
        return (function(__iced_k) {
          if (!((username != null) || (email != null))) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.get_email_or_username_i"
              });
              prompt_email_or_username(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    email = arguments[1].email;
                    return username = arguments[1].username;
                  };
                })(),
                lineno: 42
              }));
              __iced_deferrals._fulfill();
            })(function() {
              return __iced_k(err == null ? (c = env().config, email != null ? c.set("user.email", email) : void 0, username != null ? c.set("user.name", username) : void 0) : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, username || email);
        };
      })(this));
    };

    function Session() {
      this._file = null;
      this._loaded = false;
      this._id = null;
      this._logged_in = false;
      this._salt = null;
      this._passphrase = null;
      this._load_and_checked = false;
    }

    Session.prototype.load_and_login = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      err = null;
      (function(_this) {
        return (function(__iced_k) {
          if (!((_this._file != null) && _this._loaded)) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.load_and_login"
              });
              _this.load(__iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    return err = arguments[0];
                  };
                })(),
                lineno: 64
              }));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (err == null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/session.iced",
                  funcname: "Session.load_and_login"
                });
                _this.login(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return err = arguments[0];
                    };
                  })(),
                  lineno: 65
                }));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            return cb(err);
          });
        };
      })(this));
    };

    Session.prototype.load_and_check = function(cb) {
      var esc, li_post, li_pre, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Session::load_and_check");
      log.debug("+ session::load_and_check");
      ret = null;
      (function(_this) {
        return (function(__iced_k) {
          if (_this._load_and_checked) {
            log.debug("| already loaded and checked");
            return __iced_k(ret = _this.logged_in());
          } else {
            (function(__iced_k) {
              if (!((_this._file != null) && _this._loaded)) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/session.iced",
                    funcname: "Session.load_and_check"
                  });
                  _this.load(esc(__iced_deferrals.defer({
                    lineno: 78
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              li_pre = _this.logged_in();
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/session.iced",
                  funcname: "Session.load_and_check"
                });
                _this.check(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return li_post = arguments[0];
                    };
                  })(),
                  lineno: 80
                })));
                __iced_deferrals._fulfill();
              })(function() {
                _this._load_and_checked = true;
                (function(__iced_k) {
                  if (li_pre && !li_post) {
                    _this._file.clear();
                    req.clear_session();
                    req.clear_csrf();
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/session.iced",
                        funcname: "Session.load_and_check"
                      });
                      _this._file.write(esc(__iced_deferrals.defer({
                        lineno: 86
                      })));
                      __iced_deferrals._fulfill();
                    })(__iced_k);
                  } else {
                    return __iced_k();
                  }
                })(function() {
                  return __iced_k(ret = li_post);
                });
              });
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- session::load_and_check -> " + ret);
          return cb(null, ret);
        };
      })(this));
    };

    Session.prototype.load = function(cb) {
      var c, err, o, s, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ session::load");
      if (!this._file) {
        this._file = new Config(env().get_session_filename(), {
          quiet: true,
          secret: true
        });
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.load"
          });
          _this._file.open(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 97
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if ((typeof err === "undefined" || err === null) && _this._file.found) {
            _this._loaded = true;
            if ((o = _this._file.obj()) != null) {
              if ((s = o.session) != null) {
                req.set_session(s);
                _this._id = s;
              }
              if ((c = o.csrf) != null) {
                req.set_csrf(c);
                _this._csrf = c;
              }
            }
          }
          log.debug("- session::load");
          return cb(err);
        };
      })(this));
    };

    Session.prototype.set_id = function(s) {
      this._id = s;
      req.set_session(s);
      return this._file.set("session", s);
    };

    Session.prototype.set_csrf = function(c) {
      this._csrf = c;
      req.set_csrf(c);
      return this._file.set("csrf", c);
    };

    Session.prototype.write = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "write");
      (function(_this) {
        return (function(__iced_k) {
          if (!_this._loaded) {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.write"
              });
              _this.load(esc(__iced_deferrals.defer({
                lineno: 128
              })));
              __iced_deferrals._fulfill();
            })(__iced_k);
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/session.iced",
              funcname: "Session.write"
            });
            _this._file.write(esc(__iced_deferrals.defer({
              lineno: 129
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.write"
              });
              env().config.write(esc(__iced_deferrals.defer({
                lineno: 130
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null);
            });
          });
        };
      })(this));
    };

    Session.prototype.gen_pwh = function(_arg, cb) {
      var err, extra_keymaterial, km, passphrase, progress_hook, salt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      passphrase = _arg.passphrase, salt = _arg.salt;
      salt || (salt = this._salt);
      this.enc = new triplesec.Encryptor({
        key: new Buffer(passphrase, 'utf8'),
        version: SC.triplesec.version
      });
      progress_hook = make_scrypt_progress_hook();
      extra_keymaterial = SC.pwh.derived_key_bytes + SC.openpgp.derived_key_bytes;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.gen_pwh"
          });
          _this.enc.resalt({
            salt: salt,
            extra_keymaterial: extra_keymaterial,
            progress_hook: progress_hook
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return km = arguments[1];
              };
            })(),
            lineno: 144
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this._salt = _this.enc.salt.to_buffer();
            _this._pwh = km.extra.slice(0, SC.pwh.derived_key_bytes);
            _this._pwh_version = triplesec.CURRENT_VERSION;
          }
          return cb(err, _this._pwh, _this._salt, _this._pwh_version);
        };
      })(this));
    };

    Session.prototype.gen_hmac_pwh = function(_arg, cb) {
      var err, hmac_pwh, login_session, passphrase, pwh, salt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      passphrase = _arg.passphrase, salt = _arg.salt, login_session = _arg.login_session;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.gen_hmac_pwh"
          });
          _this.gen_pwh({
            passphrase: passphrase,
            salt: salt
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return pwh = arguments[1];
              };
            })(),
            lineno: 154
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            hmac_pwh = createHmac('SHA512', pwh).update(login_session).digest();
          } else {
            hmac_pwh = null;
          }
          return cb(err, hmac_pwh);
        };
      })(this));
    };

    Session.prototype.get_id = function() {
      var _ref1, _ref2;
      return this._id || ((_ref1 = this._file) != null ? (_ref2 = _ref1.obj()) != null ? _ref2.session : void 0 : void 0);
    };

    Session.prototype.get_uid = function() {
      return this.uid;
    };

    Session.prototype.check = function(cb) {
      var body, err, t, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.debug("+ session::check");
      (function(_this) {
        return (function(__iced_k) {
          if (req.get_session()) {
            log.debug("| calling to sesscheck");
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.check"
              });
              req.get({
                endpoint: "sesscheck",
                need_cookie: true
              }, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    return body = arguments[1];
                  };
                })(),
                lineno: 172
              }));
              __iced_deferrals._fulfill();
            })(function() {
              var _ref1;
              return __iced_k(typeof err === "undefined" || err === null ? (_this._logged_in = true, _this.uid = body.logged_in_uid, env().config.set("user.id", body.logged_in_uid), _this.username = body.username, _this.username != null ? env().config.set("user.name", _this.username) : void 0, (t = body.csrf_token) != null ? _this.set_csrf(t) : void 0) : err && (err instanceof E.KeybaseError) && ((typeof body !== "undefined" && body !== null ? (_ref1 = body.status) != null ? _ref1.name : void 0 : void 0) === "BAD_SESSION") ? err = null : void 0);
            });
          } else {
            return __iced_k();
          }
        });
      })(this)((function(_this) {
        return function() {
          log.debug("- session::check");
          return cb(err, _this._logged_in);
        };
      })(this));
    };

    Session.prototype.logout = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "logout");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.logout"
          });
          _this.check(esc(__iced_deferrals.defer({
            lineno: 189
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (_this.logged_in()) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/session.iced",
                  funcname: "Session.logout"
                });
                _this.post_logout(esc(__iced_deferrals.defer({
                  lineno: 191
                })));
                __iced_deferrals._fulfill();
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              if (_this._loaded) {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/session.iced",
                    funcname: "Session.logout"
                  });
                  _this._file.unlink(esc(__iced_deferrals.defer({
                    lineno: 192
                  })));
                  __iced_deferrals._fulfill();
                })(__iced_k);
              } else {
                return __iced_k();
              }
            })(function() {
              return cb(null);
            });
          });
        };
      })(this));
    };

    Session.prototype.get_salt = function(args, cb) {
      var body, err, login_session, salt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      salt = login_session = null;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.get_salt"
          });
          req.get({
            endpoint: "getsalt",
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 199
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            salt = new Buffer(body.salt, 'hex');
            env().config.set("user.salt", body.salt);
            login_session = new Buffer(body.login_session, 'base64');
          }
          return cb(err, salt, login_session);
        };
      })(this));
    };

    Session.prototype.post_logout = function(cb) {
      var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.post_logout"
          });
          req.post({
            endpoint: "logout"
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 209
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Session.prototype.post_login = function(args, cb) {
      var body, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.post_login"
          });
          req.post({
            endpoint: "login",
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return body = arguments[1];
              };
            })(),
            lineno: 215
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            _this.clear_passphrase();
          } else {
            _this.set_id(body.session);
            _this.set_csrf(body.csrf_token);
            _this.uid = body.uid;
            _this.username = body.me.basics.username;
            env().config.set("user.id", body.uid);
            if (_this.username) {
              env().config.set("user.name", _this.username);
            }
            _this._logged_in = true;
          }
          return cb(err);
        };
      })(this));
    };

    Session.prototype.login = function(cb) {
      var args, did_login, email_or_username, esc, hmac_pwh, login_session, passphrase, salt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "login");
      did_login = false;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/session.iced",
            funcname: "Session.login"
          });
          _this.check(esc(__iced_deferrals.defer({
            lineno: 233
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if (!_this.logged_in()) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/session.iced",
                  funcname: "Session.login"
                });
                _this.get_email_or_username_i(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return email_or_username = arguments[0];
                    };
                  })(),
                  lineno: 235
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/session.iced",
                    funcname: "Session.login"
                  });
                  _this.get_passphrase({}, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return passphrase = arguments[0];
                      };
                    })(),
                    lineno: 236
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-client/src/session.iced",
                      funcname: "Session.login"
                    });
                    _this.get_salt({
                      email_or_username: email_or_username
                    }, esc(__iced_deferrals.defer({
                      assign_fn: (function() {
                        return function() {
                          salt = arguments[0];
                          return login_session = arguments[1];
                        };
                      })(),
                      lineno: 237
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/session.iced",
                        funcname: "Session.login"
                      });
                      _this.gen_hmac_pwh({
                        passphrase: passphrase,
                        salt: salt,
                        login_session: login_session
                      }, esc(__iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return hmac_pwh = arguments[0];
                          };
                        })(),
                        lineno: 238
                      })));
                      __iced_deferrals._fulfill();
                    })(function() {
                      args = {
                        email_or_username: email_or_username,
                        hmac_pwh: hmac_pwh.toString('hex'),
                        login_session: login_session.toString('base64')
                      };
                      (function(__iced_k) {
                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                          parent: ___iced_passed_deferral,
                          filename: "/home/max/src/keybase/node-client/src/session.iced",
                          funcname: "Session.login"
                        });
                        _this.post_login(args, esc(__iced_deferrals.defer({
                          lineno: 244
                        })));
                        __iced_deferrals._fulfill();
                      })(function() {
                        return __iced_k(did_login = true);
                      });
                    });
                  });
                });
              });
            } else {
              return __iced_k();
            }
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/session.iced",
                funcname: "Session.login"
              });
              _this.write(esc(__iced_deferrals.defer({
                lineno: 246
              })));
              __iced_deferrals._fulfill();
            })(function() {
              return cb(null, did_login);
            });
          });
        };
      })(this));
    };

    Session.prototype.logged_in = function() {
      return this._logged_in;
    };

    return Session;

  })();

  exports.session = _session = new Session;

  _fn = function(fname) {
    return exports[fname] = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return _session[fname].apply(_session, args);
    };
  };
  for (k in Session.prototype) {
    _fn(k);
  }

}).call(this);
