/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.GeoUtils;
import org.apache.lucene.util.NumericUtils;

abstract class GeoPointTermsEnum
extends FilteredTermsEnum {
    protected final double minLon;
    protected final double minLat;
    protected final double maxLon;
    protected final double maxLat;
    protected Range currentRange;
    private final BytesRefBuilder currentCell = new BytesRefBuilder();
    private final BytesRefBuilder nextSubRange = new BytesRefBuilder();
    private final List<Range> rangeBounds = new LinkedList<Range>();
    protected final short DETAIL_LEVEL;

    GeoPointTermsEnum(TermsEnum tenum, double minLon, double minLat, double maxLon, double maxLat) {
        super(tenum);
        long rectMinHash = GeoUtils.mortonHash(minLon, minLat);
        long rectMaxHash = GeoUtils.mortonHash(maxLon, maxLat);
        this.minLon = GeoUtils.mortonUnhashLon(rectMinHash);
        this.minLat = GeoUtils.mortonUnhashLat(rectMinHash);
        this.maxLon = GeoUtils.mortonUnhashLon(rectMaxHash);
        this.maxLat = GeoUtils.mortonUnhashLat(rectMaxHash);
        this.DETAIL_LEVEL = (short)((62 - this.computeMaxShift()) / 2);
        this.computeRange(0L, (short)61);
        assert (!this.rangeBounds.isEmpty());
        Collections.sort(this.rangeBounds);
    }

    private final void computeRange(long term, short shift) {
        long split = term | 1L << shift;
        assert (shift < 64);
        long upperMax = shift < 63 ? term | (1L << shift + 1) - 1L : -1L;
        long lowerMax = split - 1L;
        this.relateAndRecurse(term, lowerMax, shift);
        this.relateAndRecurse(split, upperMax, shift);
    }

    private void relateAndRecurse(long start, long end, short res) {
        boolean within;
        double minLon = GeoUtils.mortonUnhashLon(start);
        double minLat = GeoUtils.mortonUnhashLat(start);
        double maxLon = GeoUtils.mortonUnhashLon(end);
        double maxLat = GeoUtils.mortonUnhashLat(end);
        short level = (short)(62 - res >>> 1);
        boolean bl = within = res % 9 == 0 && this.cellWithin(minLon, minLat, maxLon, maxLat);
        if (within || level == this.DETAIL_LEVEL && this.cellIntersectsShape(minLon, minLat, maxLon, maxLat)) {
            short nextRes = (short)(res - 1);
            if (nextRes % 9 == 0) {
                this.rangeBounds.add(new Range(start, nextRes, !within));
                this.rangeBounds.add(new Range(start | 1L << nextRes, nextRes, !within));
            } else {
                this.rangeBounds.add(new Range(start, res, !within));
            }
        } else if (level < this.DETAIL_LEVEL && this.cellIntersectsMBR(minLon, minLat, maxLon, maxLat)) {
            this.computeRange(start, (short)(res - 1));
        }
    }

    protected short computeMaxShift() {
        return 36;
    }

    protected abstract boolean cellCrosses(double var1, double var3, double var5, double var7);

    protected abstract boolean cellWithin(double var1, double var3, double var5, double var7);

    protected abstract boolean cellIntersectsShape(double var1, double var3, double var5, double var7);

    protected boolean cellIntersectsMBR(double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.rectIntersects(minLon, minLat, maxLon, maxLat, this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    protected boolean cellContains(double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.rectWithin(this.minLon, this.minLat, this.maxLon, this.maxLat, minLon, minLat, maxLon, maxLat);
    }

    public boolean boundaryTerm() {
        if (this.currentRange == null) {
            throw new IllegalStateException("GeoPointTermsEnum empty or not initialized");
        }
        return this.currentRange.boundary;
    }

    private void nextRange() {
        this.currentRange = this.rangeBounds.remove(0);
        this.currentRange.fillBytesRef(this.currentCell);
    }

    protected final BytesRef nextSeekTerm(BytesRef term) {
        while (!this.rangeBounds.isEmpty()) {
            if (this.currentRange == null) {
                this.nextRange();
            }
            if (term != null && term.compareTo(this.currentCell.get()) > 0) {
                this.nextRange();
                if (!this.rangeBounds.isEmpty()) continue;
            }
            return term != null && term.compareTo(this.currentCell.get()) > 0 ? term : this.currentCell.get();
        }
        assert (this.rangeBounds.isEmpty());
        return null;
    }

    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        while (this.currentCell == null || term.compareTo(this.currentCell.get()) > 0) {
            if (this.rangeBounds.isEmpty()) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            this.rangeBounds.get(0).fillBytesRef(this.nextSubRange);
            if (term.compareTo(this.nextSubRange.get()) < 0) {
                return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
            }
            this.nextRange();
        }
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    protected abstract boolean postFilter(double var1, double var3);

    protected final class Range
    implements Comparable<Range> {
        final short shift;
        final long start;
        final boolean boundary;

        Range(long lower, short shift, boolean boundary) {
            this.boundary = boundary;
            this.start = lower;
            this.shift = shift;
        }

        private void fillBytesRef(BytesRefBuilder result) {
            assert (result != null);
            NumericUtils.longToPrefixCoded((long)this.start, (int)this.shift, (BytesRefBuilder)result);
        }

        @Override
        public int compareTo(Range other) {
            int result = Short.compare(this.shift, other.shift);
            if (result == 0) {
                return Long.compare(this.start, other.start);
            }
            return result;
        }
    }
}

