/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.object;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;

public class ObjectMapper
extends Mapper
implements AllFieldMapper.IncludeInAll,
Cloneable {
    public static final String CONTENT_TYPE = "object";
    public static final String NESTED_CONTENT_TYPE = "nested";
    private final String fullPath;
    private final boolean enabled;
    private final Nested nested;
    private final String nestedTypePathAsString;
    private final BytesRef nestedTypePathAsBytes;
    private final Query nestedTypeFilter;
    private volatile Dynamic dynamic;
    private final ContentPath.Type pathType;
    private Boolean includeInAll;
    private volatile CopyOnWriteHashMap<String, Mapper> mappers;

    ObjectMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers) {
        super(name);
        this.fullPath = fullPath;
        this.enabled = enabled;
        this.nested = nested;
        this.dynamic = dynamic;
        this.pathType = pathType;
        this.mappers = mappers == null ? new CopyOnWriteHashMap() : CopyOnWriteHashMap.copyOf(mappers);
        this.nestedTypePathAsString = "__" + fullPath;
        this.nestedTypePathAsBytes = new BytesRef((CharSequence)this.nestedTypePathAsString);
        this.nestedTypeFilter = new TermQuery(new Term("_type", this.nestedTypePathAsBytes));
    }

    protected ObjectMapper clone() {
        ObjectMapper clone;
        try {
            clone = (ObjectMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
        return clone;
    }

    public ObjectMapper mappingUpdate(Mapper mapper) {
        ObjectMapper mappingUpdate = this.clone();
        mappingUpdate.mappers = new CopyOnWriteHashMap();
        mappingUpdate.putMapper(mapper);
        return mappingUpdate;
    }

    @Override
    public String name() {
        return this.fullPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ContentPath.Type pathType() {
        return this.pathType;
    }

    public Mapper getMapper(String field) {
        return this.mappers.get(field);
    }

    @Override
    public ObjectMapper includeInAll(Boolean includeInAll) {
        if (includeInAll == null) {
            return this;
        }
        ObjectMapper clone = this.clone();
        clone.includeInAll = includeInAll;
        for (Mapper mapper : clone.mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            clone.putMapper(((AllFieldMapper.IncludeInAll)((Object)mapper)).includeInAll(includeInAll));
        }
        return clone;
    }

    @Override
    public ObjectMapper includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll == null || this.includeInAll != null) {
            return this;
        }
        ObjectMapper clone = this.clone();
        clone.includeInAll = includeInAll;
        for (Mapper mapper : clone.mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            clone.putMapper(((AllFieldMapper.IncludeInAll)((Object)mapper)).includeInAllIfNotSet(includeInAll));
        }
        return clone;
    }

    @Override
    public ObjectMapper unsetIncludeInAll() {
        if (this.includeInAll == null) {
            return this;
        }
        ObjectMapper clone = this.clone();
        clone.includeInAll = null;
        for (Mapper mapper : this.mappers.values()) {
            if (!(mapper instanceof AllFieldMapper.IncludeInAll)) continue;
            clone.putMapper(((AllFieldMapper.IncludeInAll)((Object)mapper)).unsetIncludeInAll());
        }
        return clone;
    }

    public Nested nested() {
        return this.nested;
    }

    public Query nestedTypeFilter() {
        return this.nestedTypeFilter;
    }

    protected void putMapper(Mapper mapper) {
        if (mapper instanceof AllFieldMapper.IncludeInAll) {
            mapper = ((AllFieldMapper.IncludeInAll)((Object)mapper)).includeInAllIfNotSet(this.includeInAll);
        }
        this.mappers = this.mappers.copyAndPut(mapper.simpleName(), mapper);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.mappers.values().iterator();
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String nestedTypePathAsString() {
        return this.nestedTypePathAsString;
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, boolean updateAllTypes) {
        if (!(mergeWith instanceof ObjectMapper)) {
            throw new IllegalArgumentException("Can't merge a non object mapping [" + mergeWith.name() + "] with an object mapping [" + this.name() + "]");
        }
        ObjectMapper mergeWithObject = (ObjectMapper)mergeWith;
        ObjectMapper merged = this.clone();
        merged.doMerge(mergeWithObject, updateAllTypes);
        return merged;
    }

    protected void doMerge(ObjectMapper mergeWith, boolean updateAllTypes) {
        if (this.nested().isNested()) {
            if (!mergeWith.nested().isNested()) {
                throw new IllegalArgumentException("object mapping [" + this.name() + "] can't be changed from nested to non-nested");
            }
        } else if (mergeWith.nested().isNested()) {
            throw new IllegalArgumentException("object mapping [" + this.name() + "] can't be changed from non-nested to nested");
        }
        if (mergeWith.dynamic != null) {
            this.dynamic = mergeWith.dynamic;
        }
        for (Mapper mergeWithMapper : mergeWith) {
            Mapper mergeIntoMapper = this.mappers.get(mergeWithMapper.simpleName());
            Mapper merged = mergeIntoMapper == null ? mergeWithMapper : mergeIntoMapper.merge(mergeWithMapper, updateAllTypes);
            this.putMapper(merged);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null);
        return builder;
    }

    public void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        builder.startObject(this.simpleName());
        if (this.nested.isNested()) {
            builder.field("type", NESTED_CONTENT_TYPE);
            if (this.nested.isIncludeInParent()) {
                builder.field("include_in_parent", true);
            }
            if (this.nested.isIncludeInRoot()) {
                builder.field("include_in_root", true);
            }
        } else if (this.mappers.isEmpty() && custom == null) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase(Locale.ROOT));
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        Mapper[] sortedMappers = (Mapper[])Iterables.toArray(this.mappers.values(), Mapper.class);
        Arrays.sort(sortedMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        int count = 0;
        for (Mapper mapper : sortedMappers) {
            if (mapper instanceof MetadataFieldMapper) continue;
            if (count++ == 0) {
                builder.startObject("properties");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
        builder.endObject();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.createBuilder(name);
            TypeParser.parseNested(name, node, builder);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder) && !TypeParser.parseObjectProperties(name, fieldName, fieldNode, parserContext, builder)) continue;
                iterator.remove();
            }
            return builder;
        }

        protected static boolean parseObjectOrDocumentTypeProperties(String fieldName, Object fieldNode, Mapper.TypeParser.ParserContext parserContext, Builder builder) {
            if (fieldName.equals("dynamic")) {
                String value = fieldNode.toString();
                if (value.equalsIgnoreCase("strict")) {
                    builder.dynamic(Dynamic.STRICT);
                } else {
                    builder.dynamic(XContentMapValues.nodeBooleanValue(fieldNode) ? Dynamic.TRUE : Dynamic.FALSE);
                }
                return true;
            }
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                return true;
            }
            if (fieldName.equals("properties")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (!(fieldNode instanceof Map)) {
                        throw new ElasticsearchParseException("properties must be a map type", new Object[0]);
                    }
                    TypeParser.parseProperties(builder, (Map)fieldNode, parserContext);
                }
                return true;
            }
            if (fieldName.equals("include_in_all")) {
                builder.includeInAll(XContentMapValues.nodeBooleanValue(fieldNode));
                return true;
            }
            return false;
        }

        protected static boolean parseObjectProperties(String name, String fieldName, Object fieldNode, Mapper.TypeParser.ParserContext parserContext, Builder builder) {
            if (fieldName.equals("path") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                builder.pathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                return true;
            }
            return false;
        }

        protected static void parseNested(String name, Map<String, Object> node, Builder builder) {
            boolean nested = false;
            boolean nestedIncludeInParent = false;
            boolean nestedIncludeInRoot = false;
            Object fieldNode = node.get("type");
            if (fieldNode != null) {
                String type = fieldNode.toString();
                if (type.equals(ObjectMapper.CONTENT_TYPE)) {
                    builder.nested = Nested.NO;
                } else if (type.equals(ObjectMapper.NESTED_CONTENT_TYPE)) {
                    nested = true;
                } else {
                    throw new MapperParsingException("Trying to parse an object but has a different type [" + type + "] for [" + name + "]");
                }
            }
            if ((fieldNode = node.get("include_in_parent")) != null) {
                nestedIncludeInParent = XContentMapValues.nodeBooleanValue(fieldNode);
                node.remove("include_in_parent");
            }
            if ((fieldNode = node.get("include_in_root")) != null) {
                nestedIncludeInRoot = XContentMapValues.nodeBooleanValue(fieldNode);
                node.remove("include_in_root");
            }
            if (nested) {
                builder.nested = Nested.newNested(nestedIncludeInParent, nestedIncludeInRoot);
            }
        }

        protected static void parseProperties(Builder objBuilder, Map<String, Object> propsNode, Mapper.TypeParser.ParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = propsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (fieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + fieldName + "] cannot contain '.'");
                }
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    String type;
                    Map propNode = (Map)entry.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                    } else if (propNode.get("properties") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else {
                        throw new MapperParsingException("No type specified for field [" + fieldName + "]");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("No handler for type [" + type + "] declared on field [" + fieldName + "]");
                    }
                    objBuilder.add(typeParser.parse(fieldName, propNode, parserContext));
                    propNode.remove("type");
                    DocumentMapperParser.checkNoRemainingFields(fieldName, propNode, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [fields] on field [" + fieldName + "] but got a " + fieldName.getClass());
            }
            DocumentMapperParser.checkNoRemainingFields(propsNode, parserContext.indexVersionCreated(), "DocType mapping definition has unsupported parameters: ");
        }

        protected Builder createBuilder(String name) {
            return MapperBuilders.object(name);
        }
    }

    public static class Builder<T extends Builder, Y extends ObjectMapper>
    extends Mapper.Builder<T, Y> {
        protected boolean enabled = true;
        protected Nested nested = Defaults.NESTED;
        protected Dynamic dynamic = Defaults.DYNAMIC;
        protected ContentPath.Type pathType = Defaults.PATH_TYPE;
        protected Boolean includeInAll;
        protected final List<Mapper.Builder> mappersBuilders = new ArrayList<Mapper.Builder>();

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public T enabled(boolean enabled) {
            this.enabled = enabled;
            return (T)((Builder)this.builder);
        }

        public T dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return (T)((Builder)this.builder);
        }

        public T nested(Nested nested) {
            this.nested = nested;
            return (T)((Builder)this.builder);
        }

        public T pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return (T)((Builder)this.builder);
        }

        public T includeInAll(boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        public T add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return (T)((Builder)this.builder);
        }

        @Override
        public Y build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            context.path().add(this.name);
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Object mapper = builder.build(context);
                mappers.put(((Mapper)mapper).simpleName(), (Mapper)mapper);
            }
            context.path().pathType(origPathType);
            context.path().remove();
            ObjectMapper objectMapper = this.createMapper(this.name, context.path().fullPathAsText(this.name), this.enabled, this.nested, this.dynamic, this.pathType, mappers, context.indexSettings());
            objectMapper = objectMapper.includeInAllIfNotSet(this.includeInAll);
            return (Y)objectMapper;
        }

        protected ObjectMapper createMapper(String name, String fullPath, boolean enabled, Nested nested, Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers, @Nullable Settings settings) {
            return new ObjectMapper(name, fullPath, enabled, nested, dynamic, pathType, mappers);
        }
    }

    public static class Nested {
        public static final Nested NO = new Nested(false, false, false);
        private final boolean nested;
        private final boolean includeInParent;
        private final boolean includeInRoot;

        public static Nested newNested(boolean includeInParent, boolean includeInRoot) {
            return new Nested(true, includeInParent, includeInRoot);
        }

        private Nested(boolean nested, boolean includeInParent, boolean includeInRoot) {
            this.nested = nested;
            this.includeInParent = includeInParent;
            this.includeInRoot = includeInRoot;
        }

        public boolean isNested() {
            return this.nested;
        }

        public boolean isIncludeInParent() {
            return this.includeInParent;
        }

        public boolean isIncludeInRoot() {
            return this.includeInRoot;
        }
    }

    public static enum Dynamic {
        TRUE,
        FALSE,
        STRICT;

    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Nested NESTED = Nested.NO;
        public static final Dynamic DYNAMIC = null;
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

