/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.internal.SearchContext;

public final class SearchSlowLog {
    private boolean reformat;
    private long queryWarnThreshold;
    private long queryInfoThreshold;
    private long queryDebugThreshold;
    private long queryTraceThreshold;
    private long fetchWarnThreshold;
    private long fetchInfoThreshold;
    private long fetchDebugThreshold;
    private long fetchTraceThreshold;
    private String level;
    private final ESLogger queryLogger;
    private final ESLogger fetchLogger;
    private static final String INDEX_SEARCH_SLOWLOG_PREFIX = "index.search.slowlog";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN = "index.search.slowlog.threshold.query.warn";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO = "index.search.slowlog.threshold.query.info";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG = "index.search.slowlog.threshold.query.debug";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE = "index.search.slowlog.threshold.query.trace";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN = "index.search.slowlog.threshold.fetch.warn";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO = "index.search.slowlog.threshold.fetch.info";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG = "index.search.slowlog.threshold.fetch.debug";
    public static final String INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE = "index.search.slowlog.threshold.fetch.trace";
    public static final String INDEX_SEARCH_SLOWLOG_REFORMAT = "index.search.slowlog.reformat";
    public static final String INDEX_SEARCH_SLOWLOG_LEVEL = "index.search.slowlog.level";

    SearchSlowLog(Settings indexSettings) {
        this.reformat = indexSettings.getAsBoolean(INDEX_SEARCH_SLOWLOG_REFORMAT, (Boolean)true);
        this.queryWarnThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN, TimeValue.timeValueNanos(-1L)).nanos();
        this.queryInfoThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO, TimeValue.timeValueNanos(-1L)).nanos();
        this.queryDebugThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG, TimeValue.timeValueNanos(-1L)).nanos();
        this.queryTraceThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE, TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchWarnThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN, TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchInfoThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO, TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchDebugThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG, TimeValue.timeValueNanos(-1L)).nanos();
        this.fetchTraceThreshold = indexSettings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE, TimeValue.timeValueNanos(-1L)).nanos();
        this.level = indexSettings.get(INDEX_SEARCH_SLOWLOG_LEVEL, "TRACE").toUpperCase(Locale.ROOT);
        this.queryLogger = Loggers.getLogger("index.search.slowlog.query");
        this.fetchLogger = Loggers.getLogger("index.search.slowlog.fetch");
        this.queryLogger.setLevel(this.level);
        this.fetchLogger.setLevel(this.level);
    }

    void onQueryPhase(SearchContext context, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold) {
            this.queryLogger.warn("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold) {
            this.queryLogger.info("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold) {
            this.queryLogger.debug("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold) {
            this.queryLogger.trace("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        }
    }

    void onFetchPhase(SearchContext context, long tookInNanos) {
        if (this.fetchWarnThreshold >= 0L && tookInNanos > this.fetchWarnThreshold) {
            this.fetchLogger.warn("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchInfoThreshold >= 0L && tookInNanos > this.fetchInfoThreshold) {
            this.fetchLogger.info("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchDebugThreshold >= 0L && tookInNanos > this.fetchDebugThreshold) {
            this.fetchLogger.debug("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        } else if (this.fetchTraceThreshold >= 0L && tookInNanos > this.fetchTraceThreshold) {
            this.fetchLogger.trace("{}", new SlowLogSearchContextPrinter(context, tookInNanos, this.reformat));
        }
    }

    synchronized void onRefreshSettings(Settings settings) {
        boolean reformat;
        String level;
        long fetchTraceThreshold;
        long fetchDebugThreshold;
        long fetchInfoThreshold;
        long fetchWarnThreshold;
        long queryTraceThreshold;
        long queryDebugThreshold;
        long queryInfoThreshold;
        long queryWarnThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN, TimeValue.timeValueNanos(this.queryWarnThreshold)).nanos();
        if (queryWarnThreshold != this.queryWarnThreshold) {
            this.queryWarnThreshold = queryWarnThreshold;
        }
        if ((queryInfoThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO, TimeValue.timeValueNanos(this.queryInfoThreshold)).nanos()) != this.queryInfoThreshold) {
            this.queryInfoThreshold = queryInfoThreshold;
        }
        if ((queryDebugThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG, TimeValue.timeValueNanos(this.queryDebugThreshold)).nanos()) != this.queryDebugThreshold) {
            this.queryDebugThreshold = queryDebugThreshold;
        }
        if ((queryTraceThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE, TimeValue.timeValueNanos(this.queryTraceThreshold)).nanos()) != this.queryTraceThreshold) {
            this.queryTraceThreshold = queryTraceThreshold;
        }
        if ((fetchWarnThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN, TimeValue.timeValueNanos(this.fetchWarnThreshold)).nanos()) != this.fetchWarnThreshold) {
            this.fetchWarnThreshold = fetchWarnThreshold;
        }
        if ((fetchInfoThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO, TimeValue.timeValueNanos(this.fetchInfoThreshold)).nanos()) != this.fetchInfoThreshold) {
            this.fetchInfoThreshold = fetchInfoThreshold;
        }
        if ((fetchDebugThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG, TimeValue.timeValueNanos(this.fetchDebugThreshold)).nanos()) != this.fetchDebugThreshold) {
            this.fetchDebugThreshold = fetchDebugThreshold;
        }
        if ((fetchTraceThreshold = settings.getAsTime(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE, TimeValue.timeValueNanos(this.fetchTraceThreshold)).nanos()) != this.fetchTraceThreshold) {
            this.fetchTraceThreshold = fetchTraceThreshold;
        }
        if (!(level = settings.get(INDEX_SEARCH_SLOWLOG_LEVEL, this.level)).equals(this.level)) {
            this.queryLogger.setLevel(level.toUpperCase(Locale.ROOT));
            this.fetchLogger.setLevel(level.toUpperCase(Locale.ROOT));
            this.level = level;
        }
        if ((reformat = settings.getAsBoolean(INDEX_SEARCH_SLOWLOG_REFORMAT, (Boolean)this.reformat).booleanValue()) != this.reformat) {
            this.reformat = reformat;
        }
    }

    private static class SlowLogSearchContextPrinter {
        private final SearchContext context;
        private final long tookInNanos;
        private final boolean reformat;

        public SlowLogSearchContextPrinter(SearchContext context, long tookInNanos, boolean reformat) {
            this.context = context;
            this.tookInNanos = tookInNanos;
            this.reformat = reformat;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("took[").append(TimeValue.timeValueNanos(this.tookInNanos)).append("], took_millis[").append(TimeUnit.NANOSECONDS.toMillis(this.tookInNanos)).append("], ");
            if (this.context.types() == null) {
                sb.append("types[], ");
            } else {
                sb.append("types[");
                Strings.arrayToDelimitedString(this.context.types(), ",", sb);
                sb.append("], ");
            }
            if (this.context.groupStats() == null) {
                sb.append("stats[], ");
            } else {
                sb.append("stats[");
                Strings.collectionToDelimitedString(this.context.groupStats(), ",", "", "", sb);
                sb.append("], ");
            }
            sb.append("search_type[").append((Object)this.context.searchType()).append("], total_shards[").append(this.context.numberOfShards()).append("], ");
            if (this.context.request().source() != null && this.context.request().source().length() > 0) {
                try {
                    sb.append("source[").append(XContentHelper.convertToJson(this.context.request().source(), this.reformat)).append("], ");
                }
                catch (IOException e) {
                    sb.append("source[_failed_to_convert_], ");
                }
            } else {
                sb.append("source[], ");
            }
            if (this.context.request().extraSource() != null && this.context.request().extraSource().length() > 0) {
                try {
                    sb.append("extra_source[").append(XContentHelper.convertToJson(this.context.request().extraSource(), this.reformat)).append("], ");
                }
                catch (IOException e) {
                    sb.append("extra_source[_failed_to_convert_], ");
                }
            } else {
                sb.append("extra_source[], ");
            }
            return sb.toString();
        }
    }
}

