/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.EnhancedTreeCellRenderer;
import org.gjt.sp.util.Log;

public abstract class OptionsDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private String name;
    private JSplitPane splitter;
    protected JTree paneTree;
    private JScrollPane stage;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    protected OptionPane currentPane;
    private Map<Object, OptionPane> deferredOptionPanes;

    protected OptionsDialog(Frame frame, String string, String string2) {
        super(frame, jEdit.getProperty(string + ".title"), true);
        this.init(string, string2);
    }

    protected OptionsDialog(Dialog dialog, String string, String string2) {
        super(dialog, jEdit.getProperty(string + ".title"), true);
        this.init(string, string2);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.getDefaultGroup().addOptionGroup(optionGroup);
    }

    public void addOptionPane(OptionPane optionPane) {
        this.getDefaultGroup().addOptionPane(optionPane);
    }

    @Override
    public void ok() {
        this.ok(true);
    }

    @Override
    public void cancel() {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        this.dispose();
    }

    public void ok(boolean bl) {
        if (this.currentPane != null) {
            jEdit.setProperty(this.name + ".last", this.currentPane.getName());
        }
        OptionTreeModel optionTreeModel = (OptionTreeModel)this.paneTree.getModel();
        this.save(optionTreeModel.getRoot());
        jEdit.propertiesChanged();
        jEdit.saveSettings();
        if (bl) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        GUIUtilities.saveGeometry(this, this.name);
        jEdit.setIntegerProperty(this.name + ".splitter", this.splitter.getDividerLocation());
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.apply) {
            this.ok(false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof String) && !(object instanceof OptionPane)) {
            return;
        }
        Object[] objectArray = treePath.getPath();
        StringBuilder stringBuilder = new StringBuilder();
        OptionPane optionPane = null;
        int n2 = objectArray.length - 1;
        int n3 = n = this.paneTree.isRootVisible() ? 0 : 1;
        while (n <= n2) {
            block10: {
                String string;
                block8: {
                    String string2;
                    block11: {
                        Object object2;
                        block9: {
                            block7: {
                                object2 = objectArray[n];
                                if (!(object2 instanceof OptionPane)) break block7;
                                optionPane = (OptionPane)object2;
                                string = jEdit.getProperty("options." + optionPane.getName() + ".label");
                                break block8;
                            }
                            if (!(object2 instanceof OptionGroup)) break block9;
                            string = ((OptionGroup)object2).getLabel();
                            break block8;
                        }
                        if (!(object2 instanceof String)) break block10;
                        string = jEdit.getProperty("options." + object2 + ".label");
                        optionPane = this.deferredOptionPanes.get(object2);
                        if (optionPane != null) break block8;
                        string2 = "options." + object2 + ".code";
                        String string3 = jEdit.getProperty(string2);
                        if (string3 == null) break block11;
                        optionPane = (OptionPane)BeanShell.eval(jEdit.getActiveView(), BeanShell.getNameSpace(), string3);
                        if (optionPane == null) break block10;
                        this.deferredOptionPanes.put(object2, optionPane);
                        break block8;
                    }
                    Log.log(9, this, string2 + " not defined");
                    break block10;
                }
                stringBuilder.append(string);
                if (n != n2) {
                    stringBuilder.append(": ");
                }
            }
            ++n;
        }
        if (optionPane == null) {
            return;
        }
        this.setTitle(jEdit.getProperty("options.title-template", new Object[]{jEdit.getProperty(this.name + ".title"), stringBuilder.toString()}));
        try {
            optionPane.init();
        }
        catch (Throwable throwable) {
            Log.log(9, this, "Error initializing options:", throwable);
        }
        this.currentPane = optionPane;
        this.stage.setViewportView(this.currentPane.getComponent());
        this.stage.revalidate();
        this.stage.repaint();
        this.updateSize();
        this.currentPane = optionPane;
    }

    protected abstract OptionTreeModel createOptionTreeModel();

    protected abstract OptionGroup getDefaultGroup();

    protected void init(String string, String string2) {
        int n;
        this.name = string;
        this.deferredOptionPanes = new HashMap<Object, OptionPane>();
        if (string2 == null) {
            string2 = jEdit.getProperty(string + ".last");
        }
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.stage = new JScrollPane();
        this.paneTree = new JTree(this.createOptionTreeModel());
        this.paneTree.setVisibleRowCount(1);
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        if (!OperatingSystem.isMacOSLF()) {
            this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane(this.paneTree, 22, 30);
        jScrollPane.setMinimumSize(new Dimension(100, 0));
        this.splitter = new JSplitPane(1, jScrollPane, this.stage);
        jPanel.add((Component)this.splitter, "Center");
        Box box = new Box(0);
        box.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        box.add(this.cancel);
        box.add(Box.createHorizontalStrut(6));
        this.apply = new JButton(jEdit.getProperty("common.apply"));
        this.apply.addActionListener(this);
        box.add(this.apply);
        box.add(Box.createGlue());
        jPanel.add((Component)box, "South");
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        OptionGroup optionGroup = (OptionGroup)this.paneTree.getModel().getRoot();
        for (n = 0; n < optionGroup.getMemberCount(); ++n) {
            this.paneTree.expandPath(new TreePath(new Object[]{optionGroup, optionGroup.getMember(n)}));
        }
        if (!this.selectPane(optionGroup, string2)) {
            this.selectPane(optionGroup, null);
        }
        this.splitter.setDividerLocation(this.paneTree.getPreferredSize().width + jScrollPane.getVerticalScrollBar().getPreferredSize().width);
        GUIUtilities.loadGeometry(this, string);
        n = jEdit.getIntegerProperty(string + ".splitter", -1);
        if (n != -1) {
            this.splitter.setDividerLocation(n);
        }
        this.updateSize();
        this.setVisible(true);
    }

    private boolean selectPane(OptionGroup optionGroup, String string) {
        return this.selectPane(optionGroup, string, new ArrayList<Object>());
    }

    private boolean selectPane(OptionGroup optionGroup, String string, List<Object> list) {
        list.add(optionGroup);
        Enumeration<Object> enumeration = optionGroup.getMembers();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2 = enumeration.nextElement();
            if (object2 instanceof OptionGroup) {
                object = (OptionGroup)object2;
                if (((OptionGroup)object).getName().equals(string)) {
                    list.add(object);
                    list.add(((OptionGroup)object).getMember(0));
                    TreePath treePath = new TreePath(list.toArray());
                    this.paneTree.scrollPathToVisible(treePath);
                    this.paneTree.setSelectionPath(treePath);
                    return true;
                }
                if (!this.selectPane((OptionGroup)object2, string, list)) continue;
                return true;
            }
            if (object2 instanceof OptionPane) {
                object = (OptionPane)object2;
                if (!object.getName().equals(string) && string != null) continue;
                list.add(object);
                TreePath treePath = new TreePath(list.toArray());
                this.paneTree.scrollPathToVisible(treePath);
                this.paneTree.setSelectionPath(treePath);
                return true;
            }
            if (!(object2 instanceof String) || !((String)(object = (String)object2)).equals(string) && string != null) continue;
            list.add(object);
            TreePath treePath = new TreePath(list.toArray());
            this.paneTree.scrollPathToVisible(treePath);
            this.paneTree.setSelectionPath(treePath);
            return true;
        }
        list.remove(optionGroup);
        return false;
    }

    private void save(Object object) {
        if (object instanceof OptionGroup) {
            OptionGroup optionGroup = (OptionGroup)object;
            Enumeration<Object> enumeration = optionGroup.getMembers();
            while (enumeration.hasMoreElements()) {
                this.save(enumeration.nextElement());
            }
        } else if (object instanceof OptionPane) {
            try {
                ((OptionPane)object).save();
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Error saving options:", throwable);
            }
        } else if (object instanceof String) {
            this.save(this.deferredOptionPanes.get(object));
        }
    }

    private void updateSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        if (dimension3.width < 300) {
            dimension3.width = 300;
        }
        if (dimension3.height < 200) {
            dimension3.height = 200;
        }
        this.setSize(dimension3);
        this.validate();
    }

    public class OptionTreeModel
    implements TreeModel {
        private final OptionGroup root;
        private final EventListenerList listenerList = new EventListenerList();

        public OptionTreeModel() {
            this(new OptionGroup(null));
        }

        public OptionTreeModel(OptionGroup optionGroup) {
            this.root = optionGroup;
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(TreeModelListener.class, treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(TreeModelListener.class, treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMember(n);
            }
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof OptionGroup) {
                return ((OptionGroup)object).getMemberIndex(object2);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object object) {
            return !(object instanceof OptionGroup);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        protected void fireNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
            }
        }

        protected void fireNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
            }
        }

        protected void fireNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
            }
        }

        protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
            Object[] objectArray3 = this.listenerList.getListenerList();
            TreeModelEvent treeModelEvent = null;
            for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
                if (objectArray3[i] != TreeModelListener.class) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
            }
        }
    }

    public static class PaneNameRenderer
    extends EnhancedTreeCellRenderer {
        private Font paneFont = UIManager.getFont("Tree.font");
        private final Font groupFont;

        public PaneNameRenderer() {
            if (this.paneFont == null) {
                this.paneFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.groupFont = this.paneFont.deriveFont(1);
        }

        @Override
        protected TreeCellRenderer newInstance() {
            return new PaneNameRenderer();
        }

        @Override
        protected void configureTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = null;
            if (object instanceof OptionGroup) {
                this.setText(((OptionGroup)object).getLabel());
                this.setFont(this.groupFont);
            } else if (object instanceof OptionPane) {
                string = ((OptionPane)object).getName();
                this.setFont(this.paneFont);
            } else if (object instanceof String) {
                string = (String)object;
                this.setFont(this.paneFont);
            }
            if (string != null) {
                String string2 = jEdit.getProperty("options." + string + ".label");
                if (string2 == null) {
                    this.setText("NO LABEL PROPERTY: " + string);
                } else {
                    this.setText(string2);
                }
            }
            this.setIcon(null);
        }
    }
}

