/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.files;

import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileToJar(JarOutputStream jar, File source, String entryName) throws IOException {
        BufferedInputStream in = null;
        try {
            int count;
            JarEntry entry = new JarEntry(entryName);
            entry.setTime(source.lastModified());
            jar.putNextEntry(entry);
            in = new BufferedInputStream(new FileInputStream(source));
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) != -1) {
                jar.write(buffer, 0, count);
            }
            jar.closeEntry();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void makeDirsForFile(File file) {
        File dir = file.getParentFile();
        if (!(dir == null || dir.exists() || dir.mkdirs() || dir.exists())) {
            throw new JadxRuntimeException("Can't create directory " + dir);
        }
    }
}

