/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools;

import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeInstrument;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultSimpleInstrumentListener;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class CoverageTracker
extends Instrumenter.Tool {
    private final Map<LineLocation, CoverageRecord> coverageMap = new HashMap<LineLocation, CoverageRecord>();
    private final List<ProbeInstrument> instruments = new ArrayList<ProbeInstrument>();
    private final SyntaxTag countingTag;
    private final ProbeListener probeListener = new CoverageProbeListener();

    public CoverageTracker() {
        this(StandardSyntaxTag.STATEMENT);
    }

    public CoverageTracker(SyntaxTag tag) {
        this.countingTag = tag;
    }

    @Override
    protected boolean internalInstall() {
        Instrumenter instrumenter = this.getInstrumenter();
        for (Probe probe : instrumenter.findProbesTaggedAs(this.countingTag)) {
            this.addCoverageCounter(probe);
        }
        instrumenter.addProbeListener(this.probeListener);
        return true;
    }

    @Override
    protected void internalReset() {
        this.coverageMap.clear();
    }

    @Override
    protected void internalDispose() {
        this.getInstrumenter().removeProbeListener(this.probeListener);
        for (ProbeInstrument instrument : this.instruments) {
            instrument.dispose();
        }
    }

    public Map<Source, Long[]> getCounts() {
        TreeSet<Map.Entry<LineLocation, CoverageRecord>> entries = new TreeSet<Map.Entry<LineLocation, CoverageRecord>>(new LineLocationEntryComparator());
        for (Map.Entry<LineLocation, CoverageRecord> entry : this.coverageMap.entrySet()) {
            entries.add(entry);
        }
        HashMap<Source, Long[]> result = new HashMap<Source, Long[]>();
        Source curSource = null;
        Long[] curLineTable = null;
        for (Map.Entry<LineLocation, CoverageRecord> entry : entries) {
            LineLocation key = entry.getKey();
            Source source = key.getSource();
            int lineNo = key.getLineNumber();
            if (source != curSource) {
                if (curSource != null) {
                    result.put(curSource, curLineTable);
                }
                curSource = source;
                curLineTable = new Long[source.getLineCount()];
            }
            curLineTable[lineNo - 1] = entry.getValue().count;
        }
        if (curSource != null) {
            result.put(curSource, curLineTable);
        }
        return result;
    }

    public void print(PrintStream out) {
        out.println();
        out.println(this.countingTag.name() + " coverage:");
        TreeSet<Map.Entry<LineLocation, CoverageRecord>> entries = new TreeSet<Map.Entry<LineLocation, CoverageRecord>>(new LineLocationEntryComparator());
        for (Map.Entry<LineLocation, CoverageRecord> entry : this.coverageMap.entrySet()) {
            entries.add(entry);
        }
        Source curSource = null;
        int curLineNo = 1;
        for (Map.Entry<LineLocation, CoverageRecord> entry : entries) {
            LineLocation key = entry.getKey();
            Source source = key.getSource();
            int lineNo = key.getLineNumber();
            if (source != curSource) {
                if (curSource != null) {
                    while (curLineNo <= curSource.getLineCount()) {
                        CoverageTracker.displayLine(out, null, curSource, curLineNo++);
                    }
                }
                curSource = source;
                curLineNo = 1;
                out.println();
                out.println(source.getPath());
            }
            while (curLineNo < lineNo) {
                CoverageTracker.displayLine(out, null, curSource, curLineNo++);
            }
            CoverageTracker.displayLine(out, entry.getValue(), curSource, curLineNo++);
        }
        if (curSource != null) {
            while (curLineNo <= curSource.getLineCount()) {
                CoverageTracker.displayLine(out, null, curSource, curLineNo++);
            }
        }
    }

    private static void displayLine(PrintStream out, CoverageRecord record, Source source, int lineNo) {
        if (record == null) {
            out.format("%14s", " ");
        } else {
            out.format("(%12d)", record.count);
        }
        out.format(" %3d: ", lineNo);
        out.println(source.getCode(lineNo));
    }

    private void addCoverageCounter(Probe probe) {
        SourceSection srcSection = probe.getProbedSourceSection();
        if (srcSection == null) {
            return;
        }
        LineLocation lineLocation = srcSection.getLineLocation();
        CoverageRecord record = this.coverageMap.get(lineLocation);
        if (record != null) {
            if (srcSection.getCharIndex() > record.srcSection.getCharIndex()) {
                return;
            }
            record.instrument.dispose();
        }
        CoverageRecord coverageRecord = new CoverageRecord(srcSection);
        ProbeInstrument instrument = this.getInstrumenter().attach(probe, coverageRecord, CoverageTracker.class.getSimpleName());
        coverageRecord.instrument = instrument;
        this.instruments.add(instrument);
        this.coverageMap.put(lineLocation, coverageRecord);
    }

    private class CoverageProbeListener
    extends DefaultProbeListener {
        private CoverageProbeListener() {
        }

        @Override
        public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
            if (CoverageTracker.this.countingTag == tag) {
                CoverageTracker.this.addCoverageCounter(probe);
            }
        }
    }

    private static final class LineLocationEntryComparator
    implements Comparator<Map.Entry<LineLocation, CoverageRecord>> {
        private LineLocationEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<LineLocation, CoverageRecord> e1, Map.Entry<LineLocation, CoverageRecord> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    }

    private final class CoverageRecord
    extends DefaultSimpleInstrumentListener {
        private final SourceSection srcSection;
        private ProbeInstrument instrument;
        private long count = 0L;

        CoverageRecord(SourceSection srcSection) {
            this.srcSection = srcSection;
        }

        @Override
        public void onEnter(Probe probe) {
            if (CoverageTracker.this.isEnabled()) {
                ++this.count;
            }
        }
    }
}

