/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.resolve.LibraryResolutionErrorMessageBuilder;
import org.gradle.language.base.internal.model.DefaultVariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaData;
import org.gradle.language.base.internal.model.VariantsMetaDataHelper;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLibraryResolutionErrorMessageBuilder
implements LibraryResolutionErrorMessageBuilder {
    private static final String TARGET_PLATFORM = "targetPlatform";
    private final VariantsMetaData variantsMetaData;
    private final ModelSchemaStore schemaStore;
    private final Set<String> variantAxesToResolve;

    public DefaultLibraryResolutionErrorMessageBuilder(VariantsMetaData variantsMetaData, ModelSchemaStore schemaStore) {
        this.variantsMetaData = variantsMetaData;
        this.schemaStore = schemaStore;
        this.variantAxesToResolve = variantsMetaData.getNonNullVariantAxes();
    }

    @Override
    public String multipleCompatibleVariantsErrorMessage(String libraryName, Collection<? extends BinarySpec> binaries) {
        ArrayList<String> variantDescriptors = new ArrayList<String>(binaries.size());
        StringBuilder variantDescriptor = new StringBuilder();
        for (BinarySpec binarySpec : binaries) {
            variantDescriptor.setLength(0);
            boolean first = true;
            variantDescriptor.append("    - ").append(binarySpec.getDisplayName()).append(" [");
            VariantsMetaData metaData = DefaultVariantsMetaData.extractFrom(binarySpec, this.schemaStore.getSchema(((BinarySpecInternal)binarySpec).getPublicType()));
            for (String axis : metaData.getNonNullVariantAxes()) {
                if (first) {
                    first = false;
                } else {
                    variantDescriptor.append(", ");
                }
                variantDescriptor.append(this.renderAxisName(axis)).append(":'").append(metaData.getValueAsString(axis)).append("'");
            }
            variantDescriptor.append(TextUtil.toPlatformLineSeparators((String)"]\n"));
            variantDescriptors.add(variantDescriptor.toString());
        }
        StringBuilder sb = new StringBuilder(String.format(TextUtil.toPlatformLineSeparators((String)"Multiple compatible variants found for library '%s':\n"), libraryName));
        for (String descriptor : variantDescriptors) {
            sb.append(descriptor);
        }
        return sb.toString();
    }

    @Override
    public String noCompatibleVariantErrorMessage(String libraryName, Collection<BinarySpec> allBinaries) {
        HashMultimap variantAxisMessages = HashMultimap.create();
        for (BinarySpec spec : allBinaries) {
            VariantsMetaData md = DefaultVariantsMetaData.extractFrom(spec, this.schemaStore.getSchema(((BinarySpecInternal)spec).getPublicType()));
            Set<String> variantAxesWithIncompatibleTypes = VariantsMetaDataHelper.determineAxesWithIncompatibleTypes(this.variantsMetaData, md, this.variantAxesToResolve);
            for (String variantAxis : this.variantAxesToResolve) {
                String value = md.getValueAsString(variantAxis);
                if (value == null) continue;
                String message = String.format("'%s'", value);
                if (variantAxesWithIncompatibleTypes.contains(variantAxis)) {
                    message = String.format("%s but with an incompatible type (expected '%s' was '%s')", message, this.variantsMetaData.getVariantAxisType(variantAxis).getConcreteClass().getName(), md.getVariantAxisType(variantAxis).getConcreteClass().getName());
                }
                variantAxisMessages.put((Object)variantAxis, (Object)message);
            }
        }
        Joiner joiner = Joiner.on((String)", ").skipNulls();
        StringBuilder error = new StringBuilder(String.format(TextUtil.toPlatformLineSeparators((String)"Cannot find a compatible variant for library '%s'.\n"), libraryName));
        for (String variantAxis : this.variantAxesToResolve) {
            String axisName = this.renderAxisName(variantAxis);
            error.append("    Required ").append(axisName).append(" '").append(this.variantsMetaData.getValueAsString(variantAxis)).append("'");
            TreeSet available = new TreeSet(variantAxisMessages.get((Object)variantAxis));
            if (!available.isEmpty()) {
                error.append(", available: ").append(joiner.join(available)).append("\n");
                continue;
            }
            error.append(" but no compatible variant was found\n");
        }
        return error.toString();
    }

    private String renderAxisName(String variantAxis) {
        return TARGET_PLATFORM.equals(variantAxis) ? "platform" : variantAxis;
    }
}

