/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Namer;
import org.gradle.api.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Specs;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelMapGroovyView;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NamedEntityInstantiators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainObjectCollectionBackedModelMap<T>
extends ModelMapGroovyView<T> {
    private final Class<T> elementType;
    private final DomainObjectCollection<T> collection;
    private final NamedEntityInstantiator<T> instantiator;
    private final Namer<? super T> namer;
    private final Action<? super T> onCreateAction;

    public DomainObjectCollectionBackedModelMap(Class<T> elementType, DomainObjectCollection<T> backingCollection, NamedEntityInstantiator<T> instantiator, Namer<? super T> namer, Action<? super T> onCreateAction) {
        this.elementType = elementType;
        this.collection = backingCollection;
        this.instantiator = instantiator;
        this.namer = namer;
        this.onCreateAction = onCreateAction;
    }

    private <S> ModelMap<S> toNonSubtypeMap(Class<S> type) {
        DomainObjectSet<S> cast = this.toNonSubtype(type);
        Namer castNamer = (Namer)Cast.uncheckedCast(this.namer);
        return DomainObjectCollectionBackedModelMap.wrap(type, cast, NamedEntityInstantiators.nonSubtype(type, this.elementType), castNamer, Actions.doNothing());
    }

    private <S> DomainObjectSet<S> toNonSubtype(Class<S> type) {
        return (DomainObjectSet)Cast.uncheckedCast((Object)this.collection.matching(Specs.isInstance(type)));
    }

    private <S extends T> ModelMap<S> toSubtypeMap(Class<S> itemSubtype) {
        NamedEntityInstantiator instantiator = (NamedEntityInstantiator)Cast.uncheckedCast(this.instantiator);
        return DomainObjectCollectionBackedModelMap.wrap(itemSubtype, this.collection.withType(itemSubtype), instantiator, this.namer, this.onCreateAction);
    }

    @Nullable
    public T get(String name) {
        return (T)Iterables.find(this.collection, new HasNamePredicate<T>(name, this.namer), null);
    }

    public Set<String> keySet() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.collection, new ToName<T>(this.namer)));
    }

    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        this.toNonSubtype(type).all(configAction);
    }

    public static <T> DomainObjectCollectionBackedModelMap<T> wrap(Class<T> elementType, DomainObjectCollection<T> domainObjectSet, NamedEntityInstantiator<T> instantiator, Namer<? super T> namer, Action<? super T> onCreate) {
        return new DomainObjectCollectionBackedModelMap<T>(elementType, domainObjectSet, instantiator, namer, onCreate);
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Nullable
    public T get(Object name) {
        return this.get(name.toString());
    }

    public boolean containsKey(Object name) {
        return this.keySet().contains(name.toString());
    }

    public boolean containsValue(Object item) {
        return this.collection.contains(item);
    }

    public void create(String name) {
        this.create(name, this.elementType, Actions.doNothing());
    }

    public void create(String name, Action<? super T> configAction) {
        this.create(name, this.elementType, configAction);
    }

    public <S extends T> void create(String name, Class<S> type) {
        this.create(name, type, Actions.doNothing());
    }

    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        if (this.containsKey(name)) {
            throw new IllegalStateException("Entry with name already exists: " + name);
        }
        Object s = this.instantiator.create(name, type);
        configAction.execute(s);
        this.onCreateAction.execute(s);
        this.collection.add(s);
    }

    public void put(String name, T instance) {
        throw new UnsupportedOperationException();
    }

    public void named(String name, Class<? extends RuleSource> ruleSource) {
        throw new UnsupportedOperationException();
    }

    public void all(Action<? super T> configAction) {
        this.collection.all(configAction);
    }

    public void beforeEach(Action<? super T> configAction) {
        this.all(configAction);
    }

    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        throw new UnsupportedOperationException();
    }

    public void afterEach(Action<? super T> configAction) {
        this.all(configAction);
    }

    public Collection<T> values() {
        return this.collection;
    }

    public Iterator<T> iterator() {
        return this.collection.iterator();
    }

    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.withType(type, configAction);
    }

    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.withType(type, configAction);
    }

    public void named(final String name, Action<? super T> configAction) {
        this.collection.matching(new Spec<T>(){

            public boolean isSatisfiedBy(T element) {
                return DomainObjectCollectionBackedModelMap.this.get(name) == element;
            }
        }).all(configAction);
    }

    public <S> ModelMap<S> withType(Class<S> type) {
        if (type.equals(this.elementType)) {
            return (ModelMap)Cast.uncheckedCast((Object)((Object)this));
        }
        if (this.elementType.isAssignableFrom(type)) {
            Class castType = (Class)Cast.uncheckedCast(type);
            ModelMap<S> subType = this.toSubtypeMap(castType);
            return (ModelMap)Cast.uncheckedCast(subType);
        }
        return this.toNonSubtypeMap(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToName<T>
    implements Function<T, String> {
        private final Namer<? super T> namer;

        public ToName(Namer<? super T> namer) {
            this.namer = namer;
        }

        public String apply(@Nullable T input) {
            return this.namer.determineName(input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasNamePredicate<T>
    implements Predicate<T> {
        private final String name;
        private final Namer<? super T> namer;

        public HasNamePredicate(String name, Namer<? super T> namer) {
            this.name = name;
            this.namer = namer;
        }

        public boolean apply(@Nullable T input) {
            return this.namer.determineName(input).equals(this.name);
        }
    }
}

