/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.core.sym.Name1;
import com.fasterxml.jackson.core.sym.Name2;
import com.fasterxml.jackson.core.sym.Name3;
import com.fasterxml.jackson.core.sym.NameN;
import com.fasterxml.jackson.core.util.ArraysCompat;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class BytesToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 6000;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    protected final BytesToNameCanonicalizer _parent;
    protected final AtomicReference<TableInfo> _tableInfo;
    private final int _hashSeed;
    protected final boolean _intern;
    protected int _count;
    protected int _longestCollisionList;
    protected int _mainHashMask;
    protected int[] _mainHash;
    protected Name[] _mainNames;
    protected Bucket[] _collList;
    protected int _collCount;
    protected int _collEnd;
    private transient boolean _needRehash;
    private boolean _mainHashShared;
    private boolean _mainNamesShared;
    private boolean _collListShared;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private BytesToNameCanonicalizer(int n, boolean bl, int n2) {
        this._parent = null;
        this._hashSeed = n2;
        this._intern = bl;
        if (n < 16) {
            n = 16;
        } else if ((n & n - 1) != 0) {
            int n3;
            for (n3 = 16; n3 < n; n3 += n3) {
            }
            n = n3;
        }
        this._tableInfo = new AtomicReference<TableInfo>(this.initTableInfo(n));
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer bytesToNameCanonicalizer, boolean bl, int n, TableInfo tableInfo) {
        this._parent = bytesToNameCanonicalizer;
        this._hashSeed = n;
        this._intern = bl;
        this._tableInfo = null;
        this._count = tableInfo.count;
        this._mainHashMask = tableInfo.mainHashMask;
        this._mainHash = tableInfo.mainHash;
        this._mainNames = tableInfo.mainNames;
        this._collList = tableInfo.collList;
        this._collCount = tableInfo.collCount;
        this._collEnd = tableInfo.collEnd;
        this._longestCollisionList = tableInfo.longestCollisionList;
        this._needRehash = false;
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    private TableInfo initTableInfo(int n) {
        return new TableInfo(0, n - 1, new int[n], new Name[n], null, 0, 0, 0);
    }

    public static BytesToNameCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        int n = (int)l + (int)(l >>> 32) | 1;
        return BytesToNameCanonicalizer.createRoot(n);
    }

    protected static BytesToNameCanonicalizer createRoot(int n) {
        return new BytesToNameCanonicalizer(64, true, n);
    }

    public BytesToNameCanonicalizer makeChild(boolean bl, boolean bl2) {
        return new BytesToNameCanonicalizer(this, bl2, this._hashSeed, this._tableInfo.get());
    }

    public void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new TableInfo(this));
            this._mainHashShared = true;
            this._mainNamesShared = true;
            this._collListShared = true;
        }
    }

    private void mergeChild(TableInfo tableInfo) {
        int n = tableInfo.count;
        TableInfo tableInfo2 = this._tableInfo.get();
        if (n <= tableInfo2.count) {
            return;
        }
        if (n > 6000 || tableInfo.longestCollisionList > 63) {
            tableInfo = this.initTableInfo(64);
        }
        this._tableInfo.compareAndSet(tableInfo2, tableInfo);
    }

    public int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    public int bucketCount() {
        return this._mainHash.length;
    }

    public boolean maybeDirty() {
        return !this._mainHashShared;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        return this._collCount;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int n) {
        Object object;
        int n2 = this.calcHash(n);
        int n3 = n2 & this._mainHashMask;
        int n4 = this._mainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0) {
            object = this._mainNames[n3];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n)) {
                return object;
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 &= 0xFF) > 0 && (object = this._collList[--n4]) != null) {
            return ((Bucket)object).find(n2, n, 0);
        }
        return null;
    }

    public Name findName(int n, int n2) {
        Object object;
        int n3 = n2 == 0 ? this.calcHash(n) : this.calcHash(n, n2);
        int n4 = n3 & this._mainHashMask;
        int n5 = this._mainHash[n4];
        if ((n5 >> 8 ^ n3) << 8 == 0) {
            object = this._mainNames[n4];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n, n2)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this._collList[--n5]) != null) {
            return ((Bucket)object).find(n3, n, n2);
        }
        return null;
    }

    public Name findName(int[] nArray, int n) {
        Object object;
        if (n < 3) {
            return this.findName(nArray[0], n < 2 ? 0 : nArray[1]);
        }
        int n2 = this.calcHash(nArray, n);
        int n3 = n2 & this._mainHashMask;
        int n4 = this._mainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0) {
            object = this._mainNames[n3];
            if (object == null || ((Name)object).equals(nArray, n)) {
                return object;
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 &= 0xFF) > 0 && (object = this._collList[--n4]) != null) {
            return ((Bucket)object).find(n2, nArray, n);
        }
        return null;
    }

    public Name addName(String string, int n, int n2) {
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n3 = n2 == 0 ? this.calcHash(n) : this.calcHash(n, n2);
        Name name = BytesToNameCanonicalizer.constructName(n3, string, n, n2);
        this._addSymbol(n3, name);
        return name;
    }

    public Name addName(String string, int[] nArray, int n) {
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n2 = n < 3 ? (n == 1 ? this.calcHash(nArray[0]) : this.calcHash(nArray[0], nArray[1])) : this.calcHash(nArray, n);
        Name name = BytesToNameCanonicalizer.constructName(n2, string, nArray, n);
        this._addSymbol(n2, name);
        return name;
    }

    public int calcHash(int n) {
        int n2 = n ^ this._hashSeed;
        n2 += n2 >>> 15;
        n2 ^= n2 >>> 9;
        return n2;
    }

    public int calcHash(int n, int n2) {
        int n3 = n;
        n3 ^= n3 >>> 15;
        n3 += n2 * 33;
        n3 ^= this._hashSeed;
        n3 += n3 >>> 7;
        return n3;
    }

    public int calcHash(int[] nArray, int n) {
        if (n < 3) {
            throw new IllegalArgumentException();
        }
        int n2 = nArray[0] ^ this._hashSeed;
        n2 += n2 >>> 9;
        n2 *= 33;
        n2 += nArray[1];
        n2 *= 65599;
        n2 += n2 >>> 15;
        n2 ^= nArray[2];
        n2 += n2 >>> 17;
        for (int i = 3; i < n; ++i) {
            n2 = n2 * 31 ^ nArray[i];
            n2 += n2 >>> 3;
            n2 ^= n2 << 7;
        }
        n2 += n2 >>> 15;
        n2 ^= n2 << 9;
        return n2;
    }

    protected static int[] calcQuads(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[(n + 3) / 4];
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (++i < n) {
                n2 = n2 << 8 | byArray[i] & 0xFF;
                if (++i < n) {
                    n2 = n2 << 8 | byArray[i] & 0xFF;
                    if (++i < n) {
                        n2 = n2 << 8 | byArray[i] & 0xFF;
                    }
                }
            }
            nArray[i >> 2] = n2;
        }
        return nArray;
    }

    private void _addSymbol(int n, Name name) {
        int n2;
        int n3;
        if (this._mainHashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        ++this._count;
        int n4 = n & this._mainHashMask;
        if (this._mainNames[n4] == null) {
            this._mainHash[n4] = n << 8;
            if (this._mainNamesShared) {
                this.unshareNames();
            }
            this._mainNames[n4] = name;
        } else {
            Bucket bucket;
            if (this._collListShared) {
                this.unshareCollision();
            }
            ++this._collCount;
            n3 = this._mainHash[n4];
            n2 = n3 & 0xFF;
            if (n2 == 0) {
                if (this._collEnd <= 254) {
                    if ((n2 = this._collEnd++) >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    n2 = this.findBestBucket();
                }
                this._mainHash[n4] = n3 & 0xFFFFFF00 | n2 + 1;
            } else {
                --n2;
            }
            this._collList[n2] = bucket = new Bucket(name, this._collList[n2]);
            this._longestCollisionList = Math.max(bucket.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        n3 = this._mainHash.length;
        if (this._count > n3 >> 1) {
            n2 = n3 >> 2;
            if (this._count > n3 - n2) {
                this._needRehash = true;
            } else if (this._collCount >= n2) {
                this._needRehash = true;
            }
        }
    }

    private void rehash() {
        int n;
        int n2;
        this._needRehash = false;
        this._mainNamesShared = false;
        int[] nArray = this._mainHash;
        int n3 = nArray.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this.nukeSymbols();
            return;
        }
        this._mainHash = new int[n4];
        this._mainHashMask = n4 - 1;
        Name[] nameArray = this._mainNames;
        this._mainNames = new Name[n4];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Name name = nameArray[n2];
            if (name == null) continue;
            ++n5;
            int n6 = name.hashCode();
            n = n6 & this._mainHashMask;
            this._mainNames[n] = name;
            this._mainHash[n] = n6 << 8;
        }
        n2 = this._collEnd;
        if (n2 == 0) {
            this._longestCollisionList = 0;
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        int n7 = 0;
        Bucket[] bucketArray = this._collList;
        this._collList = new Bucket[bucketArray.length];
        for (n = 0; n < n2; ++n) {
            Bucket bucket = bucketArray[n];
            while (bucket != null) {
                ++n5;
                Name name = bucket._name;
                int n8 = name.hashCode();
                int n9 = n8 & this._mainHashMask;
                int n10 = this._mainHash[n9];
                if (this._mainNames[n9] == null) {
                    this._mainHash[n9] = n8 << 8;
                    this._mainNames[n9] = name;
                } else {
                    Bucket bucket2;
                    ++this._collCount;
                    int n11 = n10 & 0xFF;
                    if (n11 == 0) {
                        if (this._collEnd <= 254) {
                            if ((n11 = this._collEnd++) >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n11 = this.findBestBucket();
                        }
                        this._mainHash[n9] = n10 & 0xFFFFFF00 | n11 + 1;
                    } else {
                        --n11;
                    }
                    this._collList[n11] = bucket2 = new Bucket(name, this._collList[n11]);
                    n7 = Math.max(n7, bucket2.length());
                }
                bucket = bucket._next;
            }
        }
        this._longestCollisionList = n7;
        if (n5 != this._count) {
            throw new RuntimeException("Internal error: count after rehash " + n5 + "; should be " + this._count);
        }
    }

    private void nukeSymbols() {
        this._count = 0;
        this._longestCollisionList = 0;
        Arrays.fill(this._mainHash, 0);
        Arrays.fill(this._mainNames, null);
        Arrays.fill(this._collList, null);
        this._collCount = 0;
        this._collEnd = 0;
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this._collList;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = this._collEnd;
        for (int i = 0; i < n3; ++i) {
            int n4 = bucketArray[i].length();
            if (n4 >= n) continue;
            if (n4 == 1) {
                return i;
            }
            n = n4;
            n2 = i;
        }
        return n2;
    }

    private void unshareMain() {
        int[] nArray = this._mainHash;
        this._mainHash = ArraysCompat.copyOf(nArray, nArray.length);
        this._mainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this._collList;
        this._collList = bucketArray == null ? new Bucket[32] : ArraysCompat.copyOf(bucketArray, bucketArray.length);
        this._collListShared = false;
    }

    private void unshareNames() {
        Name[] nameArray = this._mainNames;
        this._mainNames = ArraysCompat.copyOf(nameArray, nameArray.length);
        this._mainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this._collList;
        this._collList = ArraysCompat.copyOf(bucketArray, bucketArray.length * 2);
    }

    private static Name constructName(int n, String string, int n2, int n3) {
        if (n3 == 0) {
            return new Name1(string, n, n2);
        }
        return new Name2(string, n, n2, n3);
    }

    private static Name constructName(int n, String string, int[] nArray, int n2) {
        if (n2 < 4) {
            switch (n2) {
                case 1: {
                    return new Name1(string, n, nArray[0]);
                }
                case 2: {
                    return new Name2(string, n, nArray[0], nArray[1]);
                }
                case 3: {
                    return new Name3(string, n, nArray[0], nArray[1], nArray[2]);
                }
            }
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i];
        }
        return new NameN(string, n, nArray2, n2);
    }

    protected void reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._count + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }

    static final class Bucket {
        protected final Name _name;
        protected final Bucket _next;
        private final int _length;

        Bucket(Name name, Bucket bucket) {
            this._name = name;
            this._next = bucket;
            this._length = bucket == null ? 1 : bucket._length + 1;
        }

        public int length() {
            return this._length;
        }

        public Name find(int n, int n2, int n3) {
            if (this._name.hashCode() == n && this._name.equals(n2, n3)) {
                return this._name;
            }
            Bucket bucket = this._next;
            while (bucket != null) {
                Name name = bucket._name;
                if (name.hashCode() == n && name.equals(n2, n3)) {
                    return name;
                }
                bucket = bucket._next;
            }
            return null;
        }

        public Name find(int n, int[] nArray, int n2) {
            if (this._name.hashCode() == n && this._name.equals(nArray, n2)) {
                return this._name;
            }
            Bucket bucket = this._next;
            while (bucket != null) {
                Name name = bucket._name;
                if (name.hashCode() == n && name.equals(nArray, n2)) {
                    return name;
                }
                bucket = bucket._next;
            }
            return null;
        }
    }

    private static final class TableInfo {
        public final int count;
        public final int mainHashMask;
        public final int[] mainHash;
        public final Name[] mainNames;
        public final Bucket[] collList;
        public final int collCount;
        public final int collEnd;
        public final int longestCollisionList;

        public TableInfo(int n, int n2, int[] nArray, Name[] nameArray, Bucket[] bucketArray, int n3, int n4, int n5) {
            this.count = n;
            this.mainHashMask = n2;
            this.mainHash = nArray;
            this.mainNames = nameArray;
            this.collList = bucketArray;
            this.collCount = n3;
            this.collEnd = n4;
            this.longestCollisionList = n5;
        }

        public TableInfo(BytesToNameCanonicalizer bytesToNameCanonicalizer) {
            this.count = bytesToNameCanonicalizer._count;
            this.mainHashMask = bytesToNameCanonicalizer._mainHashMask;
            this.mainHash = bytesToNameCanonicalizer._mainHash;
            this.mainNames = bytesToNameCanonicalizer._mainNames;
            this.collList = bytesToNameCanonicalizer._collList;
            this.collCount = bytesToNameCanonicalizer._collCount;
            this.collEnd = bytesToNameCanonicalizer._collEnd;
            this.longestCollisionList = bytesToNameCanonicalizer._longestCollisionList;
        }
    }
}

