/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mortbay.jetty.plus.annotation.InjectionCollection;
import org.mortbay.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.mortbay.jetty.plus.annotation.RunAsCollection;
import org.mortbay.jetty.plus.webapp.Configuration;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyConfiguration
extends Configuration {
    private List<File> classPathFiles;
    private File webXmlFile;

    public void setClassPathConfiguration(List<File> classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void configureClassLoader() throws Exception {
        if (this.classPathFiles != null) {
            Log.debug((String)"Setting up classpath ...");
            for (File classPathFile : this.classPathFiles) {
                ((WebAppClassLoader)this.getWebAppContext().getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)this.getWebAppContext().getClassLoader()).getURLs())));
            }
        } else {
            super.configureClassLoader();
        }
    }

    protected URL findWebXml() throws IOException {
        if (this.webXmlFile != null && this.webXmlFile.exists()) {
            return this.webXmlFile.toURI().toURL();
        }
        Log.debug((String)"Looking for web.xml file in WEB-INF");
        return super.findWebXml();
    }

    public void parseAnnotations() throws Exception {
        String v = System.getProperty("java.version");
        String[] version = v.split("\\.");
        if (version == null) {
            Log.info((String)"Unable to determine jvm version, annotations will not be supported");
            return;
        }
        int major = Integer.parseInt(version[0]);
        int minor = Integer.parseInt(version[1]);
        if (major >= 1 && minor >= 5) {
            ServletHolder holder;
            Class<?> annotationParserClass = Thread.currentThread().getContextClassLoader().loadClass("org.mortbay.jetty.annotations.AnnotationParser");
            Method parseAnnotationsMethod = annotationParserClass.getMethod("parseAnnotations", WebAppContext.class, Class.class, RunAsCollection.class, InjectionCollection.class, LifeCycleCallbackCollection.class);
            Iterator itor = LazyList.iterator((Object)this._servlets);
            while (itor.hasNext()) {
                holder = (ServletHolder)itor.next();
                Class servlet = this.getWebAppContext().loadClass(holder.getClassName());
                parseAnnotationsMethod.invoke(null, this.getWebAppContext(), servlet, this._runAsCollection, this._injections, this._callbacks);
            }
            itor = LazyList.iterator((Object)this._filters);
            while (itor.hasNext()) {
                holder = (FilterHolder)itor.next();
                Class filter = this.getWebAppContext().loadClass(holder.getClassName());
                parseAnnotationsMethod.invoke(null, this.getWebAppContext(), filter, null, this._injections, this._callbacks);
            }
            itor = LazyList.iterator((Object)this._listeners);
            while (itor.hasNext()) {
                Object listener = itor.next();
                parseAnnotationsMethod.invoke(null, this.getWebAppContext(), listener.getClass(), null, this._injections, this._callbacks);
            }
        } else {
            Log.info((String)"Annotations are not supported on jvms prior to jdk1.5");
        }
    }
}

