/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.result;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResolutionResult
implements ResolutionResult {
    private Factory<ResolvedComponentResult> rootSource;

    public DefaultResolutionResult(Factory<ResolvedComponentResult> rootSource) {
        assert (rootSource != null);
        this.rootSource = rootSource;
    }

    public ResolvedComponentResult getRoot() {
        return (ResolvedComponentResult)this.rootSource.create();
    }

    public Set<? extends DependencyResult> getAllDependencies() {
        final LinkedHashSet out = new LinkedHashSet();
        this.allDependencies((Action<? super DependencyResult>)new Action<DependencyResult>(){

            public void execute(DependencyResult dep) {
                out.add(dep);
            }
        });
        return out;
    }

    public void allDependencies(Action<? super DependencyResult> action) {
        this.eachElement(this.getRoot(), (Action<? super ResolvedComponentResult>)Actions.doNothing(), action, new HashSet<ResolvedComponentResult>());
    }

    public void allDependencies(Closure closure) {
        this.allDependencies((Action<? super DependencyResult>)new ClosureBackedAction(closure));
    }

    private void eachElement(ResolvedComponentResult node, Action<? super ResolvedComponentResult> moduleAction, Action<? super DependencyResult> dependencyAction, Set<ResolvedComponentResult> visited) {
        if (!visited.add(node)) {
            return;
        }
        moduleAction.execute((Object)node);
        for (DependencyResult d : node.getDependencies()) {
            dependencyAction.execute((Object)d);
            if (!(d instanceof ResolvedDependencyResult)) continue;
            this.eachElement(((ResolvedDependencyResult)d).getSelected(), moduleAction, dependencyAction, visited);
        }
    }

    public Set<ResolvedComponentResult> getAllComponents() {
        LinkedHashSet<ResolvedComponentResult> out = new LinkedHashSet<ResolvedComponentResult>();
        this.eachElement(this.getRoot(), (Action<? super ResolvedComponentResult>)Actions.doNothing(), (Action<? super DependencyResult>)Actions.doNothing(), out);
        return out;
    }

    public void allComponents(Action<? super ResolvedComponentResult> action) {
        this.eachElement(this.getRoot(), action, (Action<? super DependencyResult>)Actions.doNothing(), new HashSet<ResolvedComponentResult>());
    }

    public void allComponents(Closure closure) {
        this.allComponents((Action<? super ResolvedComponentResult>)new ClosureBackedAction(closure));
    }
}

