/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;

public class DefaultProjectComponentSelector
implements ProjectComponentSelector {
    private final String projectPath;

    public DefaultProjectComponentSelector(String projectPath) {
        assert (projectPath != null) : "project path cannot be null";
        this.projectPath = projectPath;
    }

    public String getDisplayName() {
        return "project ".concat(this.projectPath);
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)identifier;
            return this.projectPath.equals(projectComponentIdentifier.getProjectPath());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        return this.projectPath.equals(that.projectPath);
    }

    public int hashCode() {
        return this.projectPath.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector newSelector(String projectPath) {
        return new DefaultProjectComponentSelector(projectPath);
    }
}

