/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyArtifactName
implements IvyArtifactName {
    private static final String CLASSIFIER = "classifier";
    private final String name;
    private final String type;
    private final String extension;
    private final Map<String, String> attributes;

    public static DefaultIvyArtifactName forIvyArtifact(Artifact a) {
        return new DefaultIvyArtifactName(a.getName(), a.getType(), a.getExt(), a.getExtraAttributes());
    }

    public static DefaultIvyArtifactName forIvyArtifact(DependencyArtifactDescriptor a) {
        return new DefaultIvyArtifactName(a.getName(), a.getType(), a.getExt(), a.getExtraAttributes());
    }

    public static DefaultIvyArtifactName forPublishArtifact(PublishArtifact publishArtifact) {
        String name = publishArtifact.getName();
        if (name == null) {
            name = publishArtifact.getFile().getName();
        }
        String classifier = (String)GUtil.elvis((Object)publishArtifact.getClassifier(), null);
        return new DefaultIvyArtifactName(name, publishArtifact.getType(), publishArtifact.getExtension(), classifier);
    }

    public DefaultIvyArtifactName(String name, String type, @Nullable String extension, Map<String, String> attributes) {
        this.name = name;
        this.type = type;
        this.extension = extension;
        if (attributes.isEmpty()) {
            this.attributes = Collections.emptyMap();
        } else {
            this.attributes = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (!GUtil.isTrue((Object)entry.getValue())) continue;
                this.attributes.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public DefaultIvyArtifactName(String name, String type, @Nullable String extension) {
        this.name = name;
        this.type = type;
        this.extension = extension;
        this.attributes = Collections.emptyMap();
    }

    public DefaultIvyArtifactName(String name, String type, @Nullable String extension, @Nullable String classifier) {
        this.name = name;
        this.type = type;
        this.extension = extension;
        this.attributes = classifier == null ? Collections.emptyMap() : Collections.singletonMap(CLASSIFIER, classifier);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        String classifier = this.attributes.get(CLASSIFIER);
        if (GUtil.isTrue((Object)classifier)) {
            result.append("-");
            result.append(classifier);
        }
        if (GUtil.isTrue((Object)this.extension)) {
            result.append(".");
            result.append(this.extension);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode() ^ (this.extension == null ? 0 : this.extension.hashCode()) ^ this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultIvyArtifactName other = (DefaultIvyArtifactName)obj;
        return other.name.equals(this.name) && other.type.equals(this.type) && Objects.equal((Object)other.extension, (Object)this.extension) && other.attributes.equals(this.attributes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.attributes.get(CLASSIFIER);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

