/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.tooling.internal.provider.JarCache;
import org.gradle.tooling.internal.provider.PayloadClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonSidePayloadClassLoaderFactory
implements PayloadClassLoaderFactory,
Closeable {
    private final PayloadClassLoaderFactory delegate;
    private final JarCache jarCache;
    private final PersistentCache cache;

    public DaemonSidePayloadClassLoaderFactory(PayloadClassLoaderFactory delegate, JarCache jarCache, CacheRepository cacheRepository) {
        this.delegate = delegate;
        this.jarCache = jarCache;
        this.cache = cacheRepository.cache("jars-1").withDisplayName("jars").withCrossVersionCache().withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public ClassLoader getClassLoaderFor(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec instanceof MutableURLClassLoader.Spec) {
            MutableURLClassLoader.Spec urlSpec = (MutableURLClassLoader.Spec)spec;
            if (parents.size() != 1) {
                throw new IllegalStateException("Expected exactly one parent ClassLoader");
            }
            ArrayList<URL> cachedClassPath = new ArrayList<URL>(urlSpec.getClasspath().size());
            for (URL url : urlSpec.getClasspath()) {
                if (url.getProtocol().equals("file")) {
                    try {
                        final File file = new File(url.toURI());
                        if (file.isFile()) {
                            File cached = this.cache.useCache("Locate Jar file", new Factory<File>(){

                                @Override
                                public File create() {
                                    return DaemonSidePayloadClassLoaderFactory.this.jarCache.getCachedJar(file, Factories.constant(DaemonSidePayloadClassLoaderFactory.this.cache.getBaseDir()));
                                }
                            });
                            cachedClassPath.add(cached.toURI().toURL());
                            continue;
                        }
                    }
                    catch (MalformedURLException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                    catch (URISyntaxException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                }
                cachedClassPath.add(url);
            }
            return new MutableURLClassLoader(parents.get(0), cachedClassPath);
        }
        return this.delegate.getClassLoaderFor(spec, parents);
    }
}

