/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileTreeElement;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class DefaultFileVisitDetails
extends DefaultFileTreeElement
implements FileVisitDetails {
    private static final FileSystem DEFAULT_FILESYSTEM = FileSystems.getDefault();
    private final AtomicBoolean stop;
    private final boolean isDirectory;
    private final long size;
    private final long lastModified;

    public DefaultFileVisitDetails(File file, RelativePath relativePath, AtomicBoolean stop, Chmod chmod, Stat stat) {
        this(file, relativePath, stop, chmod, stat, file.isDirectory());
    }

    public DefaultFileVisitDetails(File file, RelativePath relativePath, AtomicBoolean stop, Chmod chmod, Stat stat, boolean isDirectory) {
        this(file, relativePath, stop, chmod, stat, isDirectory, file.lastModified(), file.length());
    }

    public DefaultFileVisitDetails(File file, RelativePath relativePath, AtomicBoolean stop, Chmod chmod, Stat stat, boolean isDirectory, long lastModified, long size) {
        super(file, relativePath, chmod, stat);
        this.stop = stop;
        this.isDirectory = isDirectory;
        this.lastModified = lastModified;
        this.size = size;
    }

    public DefaultFileVisitDetails(File file) {
        this(file, new RelativePath(!file.isDirectory(), file.getName()), new AtomicBoolean(), (Chmod)DEFAULT_FILESYSTEM, (Stat)DEFAULT_FILESYSTEM);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void stopVisiting() {
        this.stop.set(true);
    }
}

