/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.BuildAdapter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.component.BuildableJavaComponent;
import org.gradle.api.internal.component.ComponentRegistry;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.util.WrapUtil;

public class BuildSrcBuildListenerFactory {
    private static final String DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE = "defaultBuildSourceScript.txt";

    Listener create(boolean rebuild) {
        return new Listener(rebuild);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Listener
    extends BuildAdapter
    implements ModelConfigurationListener {
        private Set<File> classpath;
        private final boolean rebuild;

        public Listener(boolean rebuild) {
            this.rebuild = rebuild;
        }

        @Override
        public void projectsLoaded(Gradle gradle) {
            gradle.getRootProject().apply(WrapUtil.toMap("from", BuildSrcBuildListenerFactory.class.getResource(BuildSrcBuildListenerFactory.DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE)));
        }

        public Collection<File> getRuntimeClasspath() {
            return this.classpath;
        }

        @Override
        public void onConfigure(GradleInternal gradle) {
            BuildableJavaComponent projectInfo = ((ComponentRegistry)gradle.getRootProject().getServices().get(ComponentRegistry.class)).getMainComponent();
            gradle.getStartParameter().setTaskNames(this.rebuild ? projectInfo.getRebuildTasks() : projectInfo.getBuildTasks());
            this.classpath = projectInfo.getRuntimeClasspath().getFiles();
        }
    }
}

