/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal.slf4j;

import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Actions;
import org.gradle.internal.TimeProvider;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.logging.internal.slf4j.OutputEventListenerBackedLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class OutputEventListenerBackedLoggerContext
implements ILoggerFactory {
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.LIFECYCLE;
    static final String HTTP_CLIENT_WIRE_LOGGER_NAME = "org.apache.http.wire";
    static final String META_INF_EXTENSION_MODULE_LOGGER_NAME = "org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule";
    private final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final OutputStream defaultOutputStream;
    private final OutputStream defaultErrorStream;
    private final AtomicReference<LogLevel> level = new AtomicReference();
    private final AtomicReference<OutputEventListener> outputEventListener = new AtomicReference();
    private final TimeProvider timeProvider;

    public OutputEventListenerBackedLoggerContext(OutputStream defaultOutputStream, OutputStream defaultErrorStream, TimeProvider timeProvider) {
        this.defaultOutputStream = defaultOutputStream;
        this.defaultErrorStream = defaultErrorStream;
        this.timeProvider = timeProvider;
        this.applyDefaultLoggersConfig();
        this.reset();
    }

    private void applyDefaultLoggersConfig() {
        this.addNoOpLogger(HTTP_CLIENT_WIRE_LOGGER_NAME);
        this.addNoOpLogger("org.apache.http.headers");
        this.addNoOpLogger(META_INF_EXTENSION_MODULE_LOGGER_NAME);
        this.addNoOpLogger("org.littleshoot.proxy.HttpRequestHandler");
    }

    private void addNoOpLogger(String name) {
        this.loggers.put(name, new NoOpLogger(name));
    }

    public void setOutputEventListener(OutputEventListener outputEventListener) {
        this.outputEventListener.set(outputEventListener);
    }

    public OutputEventListener getOutputEventListener() {
        return this.outputEventListener.get();
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggers.get(name);
        if (logger != null) {
            return logger;
        }
        logger = this.loggers.putIfAbsent(name, new OutputEventListenerBackedLogger(name, this, this.timeProvider));
        return logger != null ? logger : (Logger)this.loggers.get(name);
    }

    public void reset() {
        this.setLevel(DEFAULT_LOG_LEVEL);
        OutputEventRenderer renderer = new OutputEventRenderer((Action<? super OutputEventRenderer>)Actions.doNothing());
        renderer.addStandardOutputListener(this.defaultOutputStream);
        renderer.addStandardErrorListener(this.defaultErrorStream);
        this.setOutputEventListener(renderer);
    }

    public LogLevel getLevel() {
        return this.level.get();
    }

    public void setLevel(LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Global log level cannot be set to null");
        }
        this.level.set(level);
    }

    private static class NoOpLogger
    implements org.gradle.api.logging.Logger {
        private final String name;

        public NoOpLogger(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public void trace(String msg) {
        }

        public void trace(String format, Object arg) {
        }

        public void trace(String format, Object arg1, Object arg2) {
        }

        public void trace(String format, Object ... arguments) {
        }

        public void trace(String msg, Throwable t) {
        }

        public boolean isTraceEnabled(Marker marker) {
            return false;
        }

        public void trace(Marker marker, String msg) {
        }

        public void trace(Marker marker, String format, Object arg) {
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void trace(Marker marker, String format, Object ... argArray) {
        }

        public void trace(Marker marker, String msg, Throwable t) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void debug(String msg) {
        }

        public void debug(String format, Object arg) {
        }

        public void debug(String format, Object arg1, Object arg2) {
        }

        public boolean isLifecycleEnabled() {
            return false;
        }

        public void debug(String format, Object ... arguments) {
        }

        public void lifecycle(String message) {
        }

        public void lifecycle(String message, Object ... objects) {
        }

        public void lifecycle(String message, Throwable throwable) {
        }

        public void debug(String msg, Throwable t) {
        }

        public boolean isDebugEnabled(Marker marker) {
            return false;
        }

        public void debug(Marker marker, String msg) {
        }

        public void debug(Marker marker, String format, Object arg) {
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void debug(Marker marker, String format, Object ... arguments) {
        }

        public void debug(Marker marker, String msg, Throwable t) {
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public void info(String msg) {
        }

        public void info(String format, Object arg) {
        }

        public void info(String format, Object arg1, Object arg2) {
        }

        public void info(String format, Object ... arguments) {
        }

        public boolean isQuietEnabled() {
            return false;
        }

        public void quiet(String message) {
        }

        public void quiet(String message, Object ... objects) {
        }

        public void quiet(String message, Throwable throwable) {
        }

        public boolean isEnabled(LogLevel level) {
            return false;
        }

        public void log(LogLevel level, String message) {
        }

        public void log(LogLevel level, String message, Object ... objects) {
        }

        public void log(LogLevel level, String message, Throwable throwable) {
        }

        public void info(String msg, Throwable t) {
        }

        public boolean isInfoEnabled(Marker marker) {
            return false;
        }

        public void info(Marker marker, String msg) {
        }

        public void info(Marker marker, String format, Object arg) {
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void info(Marker marker, String format, Object ... arguments) {
        }

        public void info(Marker marker, String msg, Throwable t) {
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void warn(String msg) {
        }

        public void warn(String format, Object arg) {
        }

        public void warn(String format, Object ... arguments) {
        }

        public void warn(String format, Object arg1, Object arg2) {
        }

        public void warn(String msg, Throwable t) {
        }

        public boolean isWarnEnabled(Marker marker) {
            return false;
        }

        public void warn(Marker marker, String msg) {
        }

        public void warn(Marker marker, String format, Object arg) {
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void warn(Marker marker, String format, Object ... arguments) {
        }

        public void warn(Marker marker, String msg, Throwable t) {
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public void error(String msg) {
        }

        public void error(String format, Object arg) {
        }

        public void error(String format, Object arg1, Object arg2) {
        }

        public void error(String format, Object ... arguments) {
        }

        public void error(String msg, Throwable t) {
        }

        public boolean isErrorEnabled(Marker marker) {
            return false;
        }

        public void error(Marker marker, String msg) {
        }

        public void error(Marker marker, String format, Object arg) {
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
        }

        public void error(Marker marker, String format, Object ... arguments) {
        }

        public void error(Marker marker, String msg, Throwable t) {
        }
    }
}

