/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.envjs.internal;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.plugins.javascript.envjs.browser.BrowserEvaluator;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateSpec;
import org.gradle.plugins.javascript.envjs.internal.EnvJsEvaluateWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandle;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandleFactory;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerSpec;
import org.gradle.process.JavaExecSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvJsBrowserEvaluator
implements BrowserEvaluator {
    private final RhinoWorkerHandleFactory rhinoWorkerHandleFactory;
    private final Iterable<File> rhinoClasspath;
    private final LogLevel logLevel;
    private final File workingDir;
    private final Factory<File> envJsFactory;

    public EnvJsBrowserEvaluator(RhinoWorkerHandleFactory rhinoWorkerHandleFactory, Iterable<File> rhinoClasspath, Factory<File> envJsFactory, LogLevel logLevel, File workingDir) {
        this.rhinoWorkerHandleFactory = rhinoWorkerHandleFactory;
        this.rhinoClasspath = rhinoClasspath;
        this.envJsFactory = envJsFactory;
        this.logLevel = logLevel;
        this.workingDir = workingDir;
    }

    @Override
    public void evaluate(String url, Writer writer) {
        RhinoWorkerHandle<String, EnvJsEvaluateSpec> handle = this.rhinoWorkerHandleFactory.create(this.rhinoClasspath, this.createWorkerSpec(), this.logLevel, new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.setWorkingDir((Object)EnvJsBrowserEvaluator.this.workingDir);
            }
        });
        String result = handle.process(new EnvJsEvaluateSpec((File)this.envJsFactory.create(), url));
        try {
            IOUtils.copy((Reader)new StringReader(result), (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private RhinoWorkerSpec<String, EnvJsEvaluateSpec> createWorkerSpec() {
        return new RhinoWorkerSpec<String, EnvJsEvaluateSpec>(String.class, EnvJsEvaluateSpec.class, EnvJsEvaluateWorker.class);
    }
}

