/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.gradle.gradleplugin.foundation.DOM4JSerializer;

public class SwingExportInteraction
implements DOM4JSerializer.ExportInteraction {
    private Window parent;

    public SwingExportInteraction(Window parent) {
        this.parent = parent;
    }

    public File promptForFile(FileFilter fileFilter) {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(fileFilter);
        if (chooser.showSaveDialog(this.parent) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public void reportError(String error) {
        JOptionPane.showMessageDialog(this.parent, error, "Error", 0);
    }

    public boolean confirmOverwritingExistingFile(File file) {
        int result = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.parent), "The file '" + file.getAbsolutePath() + "' already exists. Overwrite?", "Confirm Overwriting File", 0);
        return result == 0;
    }
}

