/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.groovy.scripts;

import java.net.URI;
import org.gradle.testkit.jarjar.org.apache.commons.lang.StringUtils;
import org.gradle.testkit.jarjar.org.gradle.groovy.scripts.ScriptSource;
import org.gradle.testkit.jarjar.org.gradle.internal.hash.HashUtil;

public abstract class AbstractUriScriptSource
implements ScriptSource {
    private String className;

    public String getClassName() {
        if (this.className == null) {
            URI sourceUri = this.getResource().getURI();
            String name = StringUtils.substringBeforeLast(StringUtils.substringAfterLast(sourceUri.toString(), "/"), ".");
            StringBuilder className = new StringBuilder(name.length());
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isJavaIdentifierPart(ch)) {
                    className.append(ch);
                    continue;
                }
                className.append('_');
            }
            if (!Character.isJavaIdentifierStart(className.charAt(0))) {
                className.insert(0, '_');
            }
            className.setLength(Math.min(className.length(), 30));
            className.append('_');
            String path = sourceUri.toString();
            className.append(HashUtil.createCompactMD5(path));
            this.className = className.toString();
        }
        return this.className;
    }
}

