/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.testkit.jarjar.org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.connection.UnsupportedActionRunner;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;

public class BuildActionRunnerBackedConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ModelProducer modelProducer;
    private final UnsupportedActionRunner actionRunner;

    public BuildActionRunnerBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R12VersionDetails(delegate.getMetaData().getVersion()));
        BuildActionRunnerBackedModelProducer consumerConnectionBackedModelProducer = new BuildActionRunnerBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (BuildActionRunner)((Object)delegate), this.getCompatibilityMapperAction());
        GradleBuildAdapterProducer producerWithGradleBuild = new GradleBuildAdapterProducer(adapter, consumerConnectionBackedModelProducer);
        this.modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), producerWithGradleBuild);
        this.actionRunner = new UnsupportedActionRunner(this.getVersionDetails().getVersion());
    }

    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildActionRunnerBackedModelProducer
    implements ModelProducer {
        private final ProtocolToModelAdapter adapter;
        private final VersionDetails versionDetails;
        private final ModelMapping modelMapping;
        private final BuildActionRunner buildActionRunner;
        private final Action<? super SourceObjectMapping> mapper;

        public BuildActionRunnerBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, BuildActionRunner buildActionRunner, Action<? super SourceObjectMapping> mapper) {
            this.adapter = adapter;
            this.versionDetails = versionDetails;
            this.modelMapping = modelMapping;
            this.buildActionRunner = buildActionRunner;
            this.mapper = mapper;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (!this.versionDetails.maySupportModel(type)) {
                throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
            }
            Class<?> protocolType = this.modelMapping.getProtocolType(type);
            Object model = this.buildActionRunner.run(protocolType, operationParameters).getModel();
            return this.adapter.adapt(type, model, this.mapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R12VersionDetails
    extends VersionDetails {
        public R12VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType.equals(ProjectOutcomes.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(BuildEnvironment.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }
}

