/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd.models;

import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.xni.QName;

public class SimpleContentModel
implements ContentModelValidator {
    public static final short CHOICE = -1;
    public static final short SEQUENCE = -1;
    private QName fFirstChild = new QName();
    private QName fSecondChild = new QName();
    private int fOperator;
    private boolean fDTD;

    public SimpleContentModel(short s, QName qName, QName qName2, boolean bl) {
        this.fFirstChild.setValues(qName);
        if (qName2 != null) {
            this.fSecondChild.setValues(qName2);
        } else {
            this.fSecondChild.clear();
        }
        this.fOperator = s;
        this.fDTD = bl;
    }

    public int validate(QName[] qNameArray, int n, int n2) {
        switch (this.fOperator) {
            case 0: {
                if (n2 == 0) {
                    return 0;
                }
                if (this.fDTD ? qNameArray[n].rawname != this.fFirstChild.rawname : qNameArray[n].uri != this.fFirstChild.uri || qNameArray[n].localpart != this.fFirstChild.localpart) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 1: {
                if (n2 == 1 && (this.fDTD ? qNameArray[n].rawname != this.fFirstChild.rawname : qNameArray[n].uri != this.fFirstChild.uri || qNameArray[n].localpart != this.fFirstChild.localpart)) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 2: {
                if (n2 <= 0) break;
                if (this.fDTD) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (qNameArray[n + n3].rawname != this.fFirstChild.rawname) {
                            return n3;
                        }
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        if (qNameArray[n + n4].uri != this.fFirstChild.uri || qNameArray[n + n4].localpart != this.fFirstChild.localpart) {
                            return n4;
                        }
                        ++n4;
                    }
                }
                break;
            }
            case 3: {
                if (n2 == 0) {
                    return 0;
                }
                if (this.fDTD) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (qNameArray[n + n5].rawname != this.fFirstChild.rawname) {
                            return n5;
                        }
                        ++n5;
                    }
                } else {
                    int n6 = 0;
                    while (n6 < n2) {
                        if (qNameArray[n + n6].uri != this.fFirstChild.uri || qNameArray[n + n6].localpart != this.fFirstChild.localpart) {
                            return n6;
                        }
                        ++n6;
                    }
                }
                break;
            }
            case 4: {
                if (n2 == 0) {
                    return 0;
                }
                if (this.fDTD ? qNameArray[n].rawname != this.fFirstChild.rawname && qNameArray[n].rawname != this.fSecondChild.rawname : !(qNameArray[n].uri == this.fFirstChild.uri && qNameArray[n].localpart == this.fFirstChild.localpart || qNameArray[n].uri == this.fSecondChild.uri && qNameArray[n].localpart == this.fSecondChild.localpart)) {
                    return 0;
                }
                if (n2 <= 1) break;
                return 1;
            }
            case 5: {
                if (n2 == 2) {
                    if (this.fDTD) {
                        if (qNameArray[n].rawname != this.fFirstChild.rawname) {
                            return 0;
                        }
                        if (qNameArray[n + 1].rawname == this.fSecondChild.rawname) break;
                        return 1;
                    }
                    if (qNameArray[n].uri != this.fFirstChild.uri || qNameArray[n].localpart != this.fFirstChild.localpart) {
                        return 0;
                    }
                    if (qNameArray[n + 1].uri == this.fSecondChild.uri && qNameArray[n + 1].localpart == this.fSecondChild.localpart) break;
                    return 1;
                }
                if (n2 > 2) {
                    return 2;
                }
                return n2;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return -1;
    }
}

