/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.openstreetmap.josm.Main;

public class CacheEntryAttributes
extends ElementAttributes {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attrs = new ConcurrentHashMap<String, String>(RESERVED_KEYS.size());
    private static final String NO_TILE_AT_ZOOM = "noTileAtZoom";
    private static final String ETAG = "Etag";
    private static final String LAST_MODIFICATION = "lastModification";
    private static final String EXPIRATION_TIME = "expirationTime";
    private static final String HTTP_RESPONSE_CODE = "httpResponceCode";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final Set<String> RESERVED_KEYS = new HashSet<String>(Arrays.asList("noTileAtZoom", "Etag", "lastModification", "expirationTime", "httpResponceCode", "errorMessage"));

    public CacheEntryAttributes() {
        this.attrs.put(NO_TILE_AT_ZOOM, "false");
        this.attrs.put(LAST_MODIFICATION, "0");
        this.attrs.put(EXPIRATION_TIME, "0");
        this.attrs.put(HTTP_RESPONSE_CODE, "200");
    }

    public boolean isNoTileAtZoom() {
        return Boolean.toString(true).equals(this.attrs.get(NO_TILE_AT_ZOOM));
    }

    public void setNoTileAtZoom(boolean bl) {
        this.attrs.put(NO_TILE_AT_ZOOM, Boolean.toString(bl));
    }

    public String getEtag() {
        return this.attrs.get(ETAG);
    }

    public void setEtag(String string) {
        if (string != null) {
            this.attrs.put(ETAG, string);
        }
    }

    private long getLongAttr(String string) {
        String string2 = this.attrs.get(string);
        if (string2 == null) {
            this.attrs.put(string, "0");
            return 0L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.attrs.put(string, "0");
            return 0L;
        }
    }

    public long getLastModification() {
        return this.getLongAttr(LAST_MODIFICATION);
    }

    public void setLastModification(long l) {
        this.attrs.put(LAST_MODIFICATION, Long.toString(l));
    }

    public long getExpirationTime() {
        return this.getLongAttr(EXPIRATION_TIME);
    }

    public void setExpirationTime(long l) {
        this.attrs.put(EXPIRATION_TIME, Long.toString(l));
    }

    public void setResponseCode(int n) {
        this.attrs.put(HTTP_RESPONSE_CODE, Integer.toString(n));
    }

    public int getResponseCode() {
        return (int)this.getLongAttr(HTTP_RESPONSE_CODE);
    }

    public void setMetadata(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (RESERVED_KEYS.contains(entry.getKey())) {
                Main.info("Metadata key configuration contains key {0} which is reserved for internal use");
                continue;
            }
            this.attrs.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.attrs);
    }

    public String getErrorMessage() {
        return this.attrs.get(ERROR_MESSAGE);
    }

    public void setErrorMessage(String string) {
        this.attrs.put(ERROR_MESSAGE, string);
    }
}

