/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.Objects;

@Deprecated
public class PrimitiveValueProfile
extends ValueProfile {
    private static final Object UNINITIALIZED = new Object();
    private static final Object GENERIC = new Object();
    @CompilerDirectives.CompilationFinal
    private Object cachedValue = UNINITIALIZED;

    PrimitiveValueProfile() {
    }

    @Override
    public <T> T profile(T v) {
        T value = v;
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Byte ? value instanceof Byte && ((Byte)snapshot).byteValue() == ((Byte)value).byteValue() : (snapshot instanceof Short ? value instanceof Short && ((Short)snapshot).shortValue() == ((Short)value).shortValue() : (snapshot instanceof Integer ? value instanceof Integer && ((Integer)snapshot).intValue() == ((Integer)value).intValue() : (snapshot instanceof Long ? value instanceof Long && ((Long)snapshot).longValue() == ((Long)value).longValue() : (snapshot instanceof Float ? value instanceof Float && PrimitiveValueProfile.exactCompare(((Float)snapshot).floatValue(), ((Float)value).floatValue()) : (snapshot instanceof Double ? value instanceof Double && PrimitiveValueProfile.exactCompare((Double)snapshot, (Double)value) : (snapshot instanceof Boolean ? value instanceof Boolean && ((Boolean)snapshot).booleanValue() == ((Boolean)value).booleanValue() : (snapshot instanceof Character ? value instanceof Character && ((Character)snapshot).charValue() == ((Character)value).charValue() : snapshot == value)))))))) {
                return (T)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public byte profile(byte value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Byte && (Byte)snapshot == value) {
                return (Byte)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public short profile(short value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Short && (Short)snapshot == value) {
                return (Short)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public int profile(int value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Integer && (Integer)snapshot == value) {
                return (Integer)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public long profile(long value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Long && (Long)snapshot == value) {
                return (Long)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public float profile(float value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Float && PrimitiveValueProfile.exactCompare(((Float)snapshot).floatValue(), value)) {
                return ((Float)snapshot).floatValue();
            }
            this.cacheMiss(Float.valueOf(value));
        }
        return value;
    }

    public double profile(double value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Double && PrimitiveValueProfile.exactCompare((Double)snapshot, value)) {
                return (Double)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public boolean profile(boolean value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Boolean && (Boolean)snapshot == value) {
                return (Boolean)snapshot;
            }
            this.cacheMiss(value);
        }
        return value;
    }

    public char profile(char value) {
        Object snapshot = this.cachedValue;
        if (snapshot != GENERIC) {
            if (snapshot instanceof Character && ((Character)snapshot).charValue() == value) {
                return ((Character)snapshot).charValue();
            }
            this.cacheMiss(Character.valueOf(value));
        }
        return value;
    }

    public boolean isGeneric() {
        return this.cachedValue == GENERIC;
    }

    public boolean isUninitialized() {
        return this.cachedValue == UNINITIALIZED;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public String toString() {
        return String.format("%s(%s)@%x", this.getClass().getSimpleName(), this.formatValue(), this.hashCode());
    }

    private void cacheMiss(Object value) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.cachedValue = this.cachedValue == UNINITIALIZED ? value : GENERIC;
    }

    public static boolean exactCompare(float a, float b) {
        return Float.floatToRawIntBits(a) == Float.floatToRawIntBits(b);
    }

    public static boolean exactCompare(double a, double b) {
        return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
    }

    private String formatValue() {
        Object snapshot = this.cachedValue;
        if (snapshot == null) {
            return "null";
        }
        if (snapshot == UNINITIALIZED) {
            return "uninitialized";
        }
        if (snapshot == GENERIC) {
            return "generic";
        }
        if (snapshot instanceof Byte || snapshot instanceof Short || snapshot instanceof Integer || snapshot instanceof Long || snapshot instanceof Float || snapshot instanceof Double || snapshot instanceof Boolean || snapshot instanceof Character) {
            return String.format("%s=%s", snapshot.getClass().getSimpleName(), snapshot);
        }
        return String.format("%s@%x", snapshot.getClass().getSimpleName(), Objects.hash(snapshot));
    }
}

