/*
 * Decompiled with CFR 0.152.
 */
package javajs.awt;

import javajs.api.GenericColor;
import javajs.awt.Dimension;
import javajs.util.CU;

public abstract class Component {
    protected boolean visible;
    protected boolean enabled = true;
    protected String text;
    protected String name;
    protected int width;
    protected int height;
    protected String id;
    protected Object parent;
    protected Object mouseListener;
    private GenericColor bgcolor;
    protected int minWidth = 30;
    protected int minHeight = 30;
    protected int renderWidth;
    protected int renderHeight;

    public void setParent(Object object) {
        this.parent = object;
    }

    protected Component(String string) {
        this.id = Component.newID(string);
        if (string == null) {
            return;
        }
    }

    public static String newID(String string) {
        return string + ("" + Math.random()).substring(3, 10);
    }

    public abstract String toHTML();

    public void setBackground(GenericColor genericColor) {
        this.bgcolor = genericColor;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setPreferredSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void addMouseListener(Object object) {
        this.mouseListener = object;
    }

    public String getText() {
        return this.text;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minWidth = dimension.width;
        this.minHeight = dimension.height;
    }

    public int getSubcomponentWidth() {
        return this.width;
    }

    public int getSubcomponentHeight() {
        return this.height;
    }

    protected String getCSSstyle(int n, int n2) {
        int n3 = this.renderWidth > 0 ? this.renderWidth : this.getSubcomponentWidth();
        int n4 = this.renderHeight > 0 ? this.renderHeight : this.getSubcomponentHeight();
        return (n3 > 0 ? "width:" + n3 + "px;" : (n > 0 ? "width:" + n + "%;" : "")) + (n4 > 0 ? "height:" + n4 + "px;" : (n2 > 0 ? "height:" + n2 + "%;" : "")) + (this.bgcolor == null ? "" : "background-color:" + CU.toCSSString(this.bgcolor) + ";");
    }

    public void repaint() {
    }
}

