/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.runtime.RubyContext;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private CallDispatchHeadNode concatNode;
    @Node.Child
    private CallDispatchHeadNode dupNode;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(RubyContext context, SourceSection sourceSection, ToSNode[] children) {
        super(context, sourceSection);
        this.children = children;
        this.concatNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
        this.taintNode = TaintNodeGen.create(context, sourceSection, null);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Object[] strings = new Object[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            Object toInterpolate;
            strings[n] = toInterpolate = this.children[n].execute(frame);
            tainted |= this.isTaintedNode.executeIsTainted(toInterpolate);
        }
        Object string = this.concat(frame, strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.executeTaint(string);
        }
        return string;
    }

    private Object concat(VirtualFrame frame, Object[] strings) {
        Object builder = null;
        for (Object string : strings) {
            assert (RubyGuards.isRubyString(string));
            builder = builder == null ? this.dupNode.call(frame, string, "dup", null, new Object[0]) : this.concatNode.call(frame, builder, "concat", null, string);
        }
        return builder;
    }
}

