/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.openoffice.xmerge.util.registry.ConverterInfo;
import org.openoffice.xmerge.util.registry.ConverterInfoReader;
import org.openoffice.xmerge.util.registry.RegistryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConverterInfoMgr {
    private static final ArrayList<ConverterInfo> converterInfoList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPlugIn(ConverterInfo ci) throws RegistryException {
        if (ci.getDisplayName() == null) {
            RegistryException re = new RegistryException("Converter must have valid name.");
            throw re;
        }
        if (ci.getClassImpl() == null) {
            RegistryException re = new RegistryException("Converter must have valid class implementation specified.");
            throw re;
        }
        if (ci.getOfficeMime() == null) {
            RegistryException re = new RegistryException("Converter must have valid office mime specified.");
            throw re;
        }
        if (!ci.getDeviceMime().hasNext()) {
            RegistryException re = new RegistryException("Converter must have valid device mime specified.");
            throw re;
        }
        for (ConverterInfo converterInfo : converterInfoList) {
            if (!ci.getDisplayName().equals(converterInfo.getDisplayName())) continue;
            RegistryException re = new RegistryException("Converter with specified display name already exists.");
            throw re;
        }
        ArrayList<ConverterInfo> arrayList = converterInfoList;
        synchronized (arrayList) {
            converterInfoList.add(ci);
        }
    }

    public static void addPlugIn(Iterator<ConverterInfo> jarEnum) throws RegistryException {
        while (jarEnum.hasNext()) {
            ConverterInfo converterInfo = jarEnum.next();
            ConverterInfoMgr.addPlugIn(converterInfo);
        }
    }

    private static Iterator<ConverterInfo> getConverterInfoEnumeration() {
        return converterInfoList.iterator();
    }

    public static boolean removeByJar(String jar) {
        boolean rc = false;
        Iterator<ConverterInfo> it = converterInfoList.iterator();
        while (it.hasNext()) {
            ConverterInfo converterInfo = it.next();
            if (!jar.equals(converterInfo.getJarName())) continue;
            it.remove();
            rc = true;
        }
        return rc;
    }

    private static boolean removeByName(String name) {
        boolean rc = false;
        Iterator<ConverterInfo> it = converterInfoList.iterator();
        while (it.hasNext()) {
            ConverterInfo converterInfo = it.next();
            if (!name.equals(converterInfo.getDisplayName())) continue;
            it.remove();
            rc = true;
        }
        return rc;
    }

    public static ConverterInfo findConverterInfo(String deviceMime, String officeMime) {
        if (deviceMime == null || !ConverterInfo.isValidOfficeType(officeMime)) {
            return null;
        }
        for (ConverterInfo converterInfo : converterInfoList) {
            String toDeviceInfo = converterInfo.getOfficeMime();
            Iterator<String> fromEnum = converterInfo.getDeviceMime();
            while (fromEnum.hasNext()) {
                String fromDeviceInfo = fromEnum.next();
                if (!deviceMime.trim().equals(fromDeviceInfo) || !officeMime.trim().equals(toDeviceInfo)) continue;
                return converterInfo;
            }
        }
        return null;
    }

    private static ConverterInfo[] findConverterInfoChain(String deviceFromMime, String deviceToMime) {
        if (deviceFromMime == null || deviceToMime == null) {
            return null;
        }
        ConverterInfo[] converterInfo = new ConverterInfo[2];
        Iterator<ConverterInfo> cifEnum = converterInfoList.iterator();
        while (cifEnum.hasNext()) {
            converterInfo[0] = cifEnum.next();
            String fromOfficeInfo = converterInfo[0].getOfficeMime();
            Iterator<String> fromEnum = converterInfo[0].getDeviceMime();
            while (fromEnum.hasNext()) {
                String fromDeviceInfo = fromEnum.next();
                if (!deviceFromMime.trim().equals(fromDeviceInfo)) continue;
                Iterator<ConverterInfo> citEnum = converterInfoList.iterator();
                while (citEnum.hasNext()) {
                    converterInfo[1] = citEnum.next();
                    String toOfficeInfo = converterInfo[1].getOfficeMime();
                    Iterator<String> toEnum = converterInfo[1].getDeviceMime();
                    while (toEnum.hasNext()) {
                        String toDeviceInfo = toEnum.next();
                        if (!deviceToMime.trim().equals(toDeviceInfo) || !fromOfficeInfo.equals(toOfficeInfo)) continue;
                        return converterInfo;
                    }
                }
            }
        }
        return null;
    }

    public static void main(String[] args) {
        ConverterInfoReader cir = null;
        boolean validate = false;
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        int c = 32;
        boolean exitFlag = false;
        while (!exitFlag) {
            System.out.println("\nMenu:");
            System.out.println("(L)oad plug-ins from a jar file");
            System.out.println("(D)isplay name unload");
            System.out.println("(J)ar name unload");
            System.out.println("(F)ind ConverterInfo");
            System.out.println("(C)ind ConverterInfo chain");
            System.out.println("(V)iew plug-ins");
            System.out.println("(T)oggle Validation");
            System.out.println("(Q)uit\n");
            try {
                c = br.readLine().toUpperCase().trim().charAt(0);
            }
            catch (Exception e) {
                System.out.println("Invalid entry");
                System.out.println("Error msg: " + e.getMessage());
                continue;
            }
            System.out.println("");
            if (c == 81) {
                exitFlag = true;
                continue;
            }
            if (c == 76) {
                System.out.println("Enter path to jarfile: ");
                try {
                    String jarname = br.readLine().trim();
                    cir = new ConverterInfoReader(jarname, validate);
                }
                catch (RegistryException e) {
                    System.out.println("Cannot load plug-in ConverterFactory implementation.");
                    System.out.println("Error msg: " + e.getMessage());
                }
                catch (Exception e) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + e.getMessage());
                }
                if (cir == null) continue;
                Iterator<ConverterInfo> jarInfoEnum = cir.getConverterInfoEnumeration();
                try {
                    ConverterInfoMgr.addPlugIn(jarInfoEnum);
                }
                catch (Exception e) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + e.getMessage());
                }
                continue;
            }
            if (c == 84) {
                if (validate) {
                    System.out.println("Validation switched off");
                    validate = false;
                    continue;
                }
                System.out.println("Validation switched on");
                validate = true;
                continue;
            }
            if (c == 68 || c == 74) {
                if (c == 68) {
                    System.out.println("Enter display name: ");
                } else {
                    System.out.println("Enter path to jarfile: ");
                }
                try {
                    String name = br.readLine().trim();
                    boolean rc = false;
                    rc = c == 68 ? ConverterInfoMgr.removeByName(name) : ConverterInfoMgr.removeByJar(name);
                    if (rc) {
                        System.out.println("Remove successful.");
                        continue;
                    }
                    System.out.println("Remove failed.");
                }
                catch (Exception e) {
                    System.out.println("Error removing value from registry");
                    System.out.println("Error msg: " + e.getMessage());
                }
                continue;
            }
            if (c == 70 || c == 67) {
                ConverterInfo[] foundInfo;
                String findMimeOne = null;
                String findMimeTwo = null;
                if (c == 70) {
                    System.out.println("Enter device mime: ");
                } else {
                    System.out.println("Enter device from mime: ");
                }
                try {
                    findMimeOne = br.readLine().trim();
                }
                catch (Exception e) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + e.getMessage());
                }
                if (c == 70) {
                    System.out.println("Enter office mime: ");
                } else {
                    System.out.println("Enter device to mime: ");
                }
                try {
                    findMimeTwo = br.readLine().trim();
                }
                catch (Exception e) {
                    System.out.println("Error adding data to registry");
                    System.out.println("Error msg: " + e.getMessage());
                }
                if (c == 70) {
                    foundInfo = ConverterInfoMgr.findConverterInfo(findMimeOne, findMimeTwo);
                    if (foundInfo != null) {
                        System.out.println("    Found ConverterInfo");
                        System.out.println("    DisplayName  : " + foundInfo.getDisplayName());
                        continue;
                    }
                    System.out.println("    Did not find ConverterInfo");
                    continue;
                }
                foundInfo = ConverterInfoMgr.findConverterInfoChain(findMimeOne, findMimeTwo);
                if (foundInfo[0] != null && foundInfo[1] != null) {
                    System.out.println("    Found ConverterInfo Chain");
                    System.out.println("    DisplayName  : " + foundInfo[0].getDisplayName());
                    System.out.println("    DisplayName  : " + foundInfo[1].getDisplayName());
                    continue;
                }
                System.out.println("    Did not find ConverterInfo");
                continue;
            }
            if (c == 86) {
                Iterator<ConverterInfo> ciEnum = ConverterInfoMgr.getConverterInfoEnumeration();
                int ciCnt = 0;
                while (ciEnum.hasNext()) {
                    System.out.println("");
                    System.out.println("  Displaying converter number " + ciCnt);
                    ConverterInfo converterInfo = ciEnum.next();
                    System.out.println("    DisplayName  : " + converterInfo.getDisplayName());
                    System.out.println("    JarFile      : " + converterInfo.getJarName());
                    System.out.println("    Description  : " + converterInfo.getDescription());
                    System.out.println("    Version      : " + converterInfo.getVersion());
                    System.out.println("    OfficeMime   : " + converterInfo.getOfficeMime());
                    Iterator<String> fromEnum = converterInfo.getDeviceMime();
                    int feCnt = 1;
                    while (fromEnum.hasNext()) {
                        System.out.println("    DeviceMime   : (#" + feCnt + ") : " + fromEnum.next());
                        ++feCnt;
                    }
                    if (feCnt == 1) {
                        System.out.println("    DeviceMime   : None specified");
                    }
                    System.out.println("    Vendor       : " + converterInfo.getVendor());
                    System.out.println("    ClassImpl    : " + converterInfo.getClassImpl());
                    System.out.println("    XsltSerial   : " + converterInfo.getXsltSerial());
                    System.out.println("    XsltDeserial : " + converterInfo.getXsltDeserial());
                    System.out.println("    Serialize    : " + converterInfo.canSerialize());
                    System.out.println("    Deserialize  : " + converterInfo.canDeserialize());
                    System.out.println("    Merge        : " + converterInfo.canMerge());
                    ++ciCnt;
                }
                if (ciCnt != 0) continue;
                System.out.println("No converters registered");
                continue;
            }
            System.out.println("Invalid input");
        }
    }
}

