/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptable
extends ScriptableObject
implements IdFunctionMaster {
    private int maxId;
    private Object[] idMapData;
    private static final boolean CACHE_NAMES = true;
    private int lastIdCache;

    public boolean has(String name, Scriptable start) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_writeCached(name)) != 0) {
            return this.hasValue(id);
        }
        return super.has(name, start);
    }

    public Object get(String name, Scriptable start) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_writeCached(name)) != 0) {
            Object[] data = this.idMapData;
            if (data == null) {
                return this.getIdValue(id);
            }
            Object value = data[id - 1];
            if (value == null) {
                value = this.getIdValue(id);
            } else if (value == UniqueTag.NULL_VALUE) {
                value = null;
            }
            return value;
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId_cached(name)) != 0) {
            if (start == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", name);
            }
            int attr = this.getIdAttributes(id);
            if ((attr & 1) == 0) {
                if (start == this) {
                    this.setIdValue(id, value);
                } else {
                    start.put(name, start, value);
                }
            }
            return;
        }
        super.put(name, start, value);
    }

    public void delete(String name) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0 && !this.isSealed()) {
            int attr = this.getIdAttributes(id);
            if ((attr & 4) == 0) {
                this.deleteIdValue(id);
            }
            return;
        }
        super.delete(name);
    }

    public int getAttributes(String name) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0 && this.hasValue(id)) {
            return this.getIdAttributes(id);
        }
        return super.getAttributes(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String name, int attributes) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(name)) != 0) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                if (this.hasValue(id)) {
                    this.setIdAttributes(id, attributes);
                    return;
                }
            }
        }
        super.setAttributes(name, attributes);
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        int id;
        if (this.maxId != 0 && (id = this.mapNameToId(propertyName)) != 0) {
            int current_attributes = this.getIdAttributes(id);
            if ((current_attributes & 1) != 0) {
                throw new RuntimeException("Attempt to redefine read-only id " + propertyName);
            }
            this.setIdAttributes(id, attributes);
            this.setIdValue(id, value);
            return;
        }
        super.defineProperty(propertyName, value, attributes);
    }

    Object[] getIds(boolean getAll) {
        Object[] result = super.getIds(getAll);
        if (this.maxId != 0) {
            Object[] ids = null;
            int count = 0;
            for (int id = this.maxId; id != 0; --id) {
                if (!this.hasValue(id) || !getAll && (this.getIdAttributes(id) & 2) != 0) continue;
                if (count == 0) {
                    ids = new Object[id];
                }
                ids[count++] = this.getIdName(id);
            }
            if (count != 0) {
                if (result.length == 0 && ids.length == count) {
                    result = ids;
                } else {
                    Object[] tmp = new Object[result.length + count];
                    System.arraycopy(result, 0, tmp, 0, result.length);
                    System.arraycopy(ids, 0, tmp, result.length, count);
                    result = tmp;
                }
            }
        }
        return result;
    }

    private int mapNameToId_cached(String name) {
        int id;
        Object[] data = this.idMapData;
        if (data != null && data[(id = this.lastIdCache) - 1 + this.maxId] == name) {
            return id;
        }
        return this.mapNameToId(name);
    }

    private int mapNameToId_writeCached(String name) {
        Object[] data = this.idMapData;
        if (data != null) {
            int id = this.lastIdCache;
            if (data[id - 1 + this.maxId] == name) {
                return id;
            }
            id = this.mapNameToId(name);
            if (id != 0) {
                data[id - 1 + this.maxId] = name;
                this.lastIdCache = id;
            }
            return id;
        }
        return this.mapNameToId(name);
    }

    protected abstract int mapNameToId(String var1);

    protected abstract String getIdName(int var1);

    protected int getIdAttributes(int id) {
        return 2;
    }

    protected void setIdAttributes(int id, int attributes) {
        int current = this.getIdAttributes(id);
        if (attributes != current) {
            throw new RuntimeException("Change of attributes for this id is not supported");
        }
    }

    protected boolean hasIdValue(int id) {
        return true;
    }

    protected Object getIdValue(int id) {
        IdFunction f = this.newIdFunction(id);
        f.setParentScope(this.getParentScope());
        return this.cacheIdValue(id, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdValue(int id, Object value) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] data = this.ensureIdData();
            data[id - 1] = value != null ? value : UniqueTag.NULL_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object cacheIdValue(int id, Object value) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] data = this.ensureIdData();
            Object curValue = data[id - 1];
            if (curValue == null) {
                data[id - 1] = value != null ? value : UniqueTag.NULL_VALUE;
            } else {
                value = curValue;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteIdValue(int id) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.ensureIdData()[id - 1] = NOT_FOUND;
        }
    }

    public Object execMethod(int methodId, IdFunction function, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        throw IdFunction.onBadMethodId(this, methodId);
    }

    public int methodArity(int methodId) {
        return -1;
    }

    protected final int getMaxId() {
        return this.maxId;
    }

    protected final void setMaxId(int maxId) {
        if (maxId < this.maxId) {
            Kit.codeBug();
        }
        this.maxId = maxId;
    }

    public void addAsPrototype(int maxId, Context cx, Scriptable scope, boolean sealed) {
        this.setMaxId(maxId);
        int constructorId = this.mapNameToId("constructor");
        if (constructorId == 0) {
            throw new RuntimeException("No id for constructor property");
        }
        IdFunction ctor = this.newIdFunction(this.getClassName(), constructorId);
        ctor.initAsConstructor(scope, this);
        this.fillConstructorProperties(cx, ctor, sealed);
        if (sealed) {
            ctor.sealObject();
        }
        this.setParentScope(ctor);
        this.setPrototype(IdScriptable.getObjectPrototype(scope));
        this.cacheIdValue(constructorId, ctor);
        if (sealed) {
            this.sealObject();
        }
        IdScriptable.defineProperty(scope, this.getClassName(), ctor, 2);
    }

    protected void fillConstructorProperties(Context cx, IdFunction ctor, boolean sealed) {
    }

    protected void addIdFunctionProperty(Scriptable obj, int id, boolean sealed) {
        IdFunction f = this.newIdFunction(id);
        if (sealed) {
            f.sealObject();
        }
        IdScriptable.defineProperty(obj, this.getIdName(id), f, 2);
    }

    protected static EcmaError incompatibleCallError(IdFunction f) {
        throw ScriptRuntime.typeError1("msg.incompat.call", f.getFunctionName());
    }

    protected IdFunction newIdFunction(int id) {
        return this.newIdFunction(this.getIdName(id), id);
    }

    protected IdFunction newIdFunction(String name, int id) {
        IdFunction f = new IdFunction(this, name, id);
        if (this.isSealed()) {
            f.sealObject();
        }
        return f;
    }

    protected final Object wrap_double(double x) {
        return x == x ? new Double(x) : ScriptRuntime.NaNobj;
    }

    protected final Object wrap_int(int x) {
        byte b = (byte)x;
        if (b == x) {
            return new Byte(b);
        }
        return new Integer(x);
    }

    protected final Object wrap_long(long x) {
        int i = (int)x;
        if ((long)i == x) {
            return this.wrap_int(i);
        }
        return new Long(x);
    }

    protected final Object wrap_boolean(boolean x) {
        return x ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean hasValue(int id) {
        Object value;
        Object[] data = this.idMapData;
        if (data == null || (value = data[id - 1]) == null) {
            return this.hasIdValue(id);
        }
        return value != NOT_FOUND;
    }

    private Object[] ensureIdData() {
        Object[] data = this.idMapData;
        if (data == null) {
            data = new Object[this.maxId * 2];
            this.idMapData = data;
        }
        return data;
    }
}

