/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.windows;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import org.openide.awt.ActionID;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.windows.TopComponent;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class TopComponentProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(TopComponent.Registration.class.getCanonicalName());
        hashSet.add(TopComponent.OpenActionRegistration.class.getCanonicalName());
        hashSet.add(TopComponent.Description.class.getCanonicalName());
        return hashSet;
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        String string;
        String string2;
        TopComponent.Description description;
        Annotation annotation;
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TopComponent.Registration.class)) {
            annotation = element.getAnnotation(TopComponent.Registration.class);
            if (annotation == null) continue;
            description = this.findInfo(element);
            if (description == null) {
                throw new LayerGenerationException("Cannot find TopComponent.Description for this element", element, this.processingEnv, annotation);
            }
            string2 = description.preferredID();
            TopComponentProcessor.checkValidId(string2, element, this.processingEnv, description);
            String[] stringArray = annotation.roles();
            if (stringArray.length == 0) {
                string = "Windows2";
                this.generateSettingsAndWstcref(element, string, string2, (TopComponent.Registration)annotation, description);
                continue;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : stringArray) {
                if (!hashSet.add(string3)) {
                    throw new LayerGenerationException("Duplicate role name found", element, this.processingEnv, annotation);
                }
                if (string3.isEmpty()) {
                    throw new LayerGenerationException("Unnamed role found", element, this.processingEnv, annotation);
                }
                string = "Windows2/Roles/" + string3;
                this.generateSettingsAndWstcref(element, string, string2, (TopComponent.Registration)annotation, description);
            }
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(TopComponent.OpenActionRegistration.class)) {
            annotation = element.getAnnotation(TopComponent.OpenActionRegistration.class);
            assert (annotation != null);
            description = this.findInfo(element);
            string2 = element.getAnnotation(ActionID.class);
            if (string2 == null) continue;
            string = this.layer(new Element[]{element}).file("Actions/" + string2.category() + "/" + string2.id().replace('.', '-') + ".instance").methodvalue("instanceCreate", "org.openide.windows.TopComponent", "openAction");
            string.instanceAttribute("component", TopComponent.class, annotation, null);
            if (annotation.preferredID().length() > 0) {
                string.stringvalue("preferredID", annotation.preferredID());
            }
            string.bundlevalue("displayName", annotation.displayName(), annotation, "displayName");
            if (description != null && description.iconBase().length() > 0) {
                string.stringvalue("iconBase", description.iconBase());
            }
            string.write();
        }
        return true;
    }

    private void generateSettingsAndWstcref(Element element, String string, String string2, TopComponent.Registration registration, TopComponent.Description description) throws LayerGenerationException {
        LayerBuilder.File file = this.layer(new Element[]{element}).file(string + "/Components/" + string2 + ".settings").contents(TopComponentProcessor.settingsFile(element));
        file.write();
        LayerBuilder.File file2 = this.layer(new Element[]{element}).file(string + "/Modes/" + registration.mode() + "/" + string2 + ".wstcref").position(registration.position()).contents(TopComponentProcessor.modeFile(description.preferredID(), registration.openAtStartup()));
        file2.write();
    }

    private TopComponent.Description findInfo(Element element) throws LayerGenerationException {
        Element element2;
        switch (element.asType().getKind()) {
            case DECLARED: {
                element2 = element;
                break;
            }
            case EXECUTABLE: {
                element2 = ((DeclaredType)((ExecutableType)element.asType()).getReturnType()).asElement();
                break;
            }
            default: {
                throw new LayerGenerationException("" + (Object)((Object)element.asType().getKind()), element);
            }
        }
        TopComponent.Description description = element2.getAnnotation(TopComponent.Description.class);
        return description;
    }

    private static String settingsFile(Element element) throws LayerGenerationException {
        String string;
        String string2;
        switch (element.getKind()) {
            case CLASS: {
                string2 = element.toString();
                string = null;
                break;
            }
            case METHOD: {
                string2 = element.getEnclosingElement().toString();
                string = element.getSimpleName().toString();
                break;
            }
            default: {
                throw new LayerGenerationException("Cannot work on given element", element);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<!DOCTYPE settings PUBLIC \"-//NetBeans//DTD Session settings 1.0//EN\" \"http://www.netbeans.org/dtds/sessionsettings-1_0.dtd\">\n");
        stringBuilder.append("<settings version=\"1.0\">\n");
        stringBuilder.append("  <instance class=\"").append(string2).append("\"");
        if (string != null) {
            stringBuilder.append(" method=\"").append(string).append("\"");
        }
        stringBuilder.append("/>\n");
        stringBuilder.append("</settings>\n");
        return stringBuilder.toString();
    }

    private static String modeFile(String string, boolean bl) throws LayerGenerationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuilder.append("<!DOCTYPE tc-ref PUBLIC \"-//NetBeans//DTD Top Component in Mode Properties 2.0//EN\" \"http://www.netbeans.org/dtds/tc-ref2_0.dtd\">\n");
        stringBuilder.append("<tc-ref version=\"2.0\">\n");
        stringBuilder.append("  <tc-id id=\"").append(string).append("\"/>\n");
        stringBuilder.append("  <state opened=\"").append(bl).append("\"/>\n");
        stringBuilder.append("</tc-ref>\n");
        return stringBuilder.toString();
    }

    private static void checkValidId(String string, Element element, ProcessingEnvironment processingEnvironment, TopComponent.Description description) throws LayerGenerationException {
        if (null == string) {
            return;
        }
        for (char c : string.toCharArray()) {
            if ((Character.isLetterOrDigit(c) || c == '-' || c == '_') && c <= '~') continue;
            throw new LayerGenerationException("The preferred id contains invalid character '" + c + "'", element, processingEnvironment, (Annotation)description);
        }
    }
}

