/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AtkAction {
    AccessibleContext ac;
    AccessibleAction acc_action;
    AccessibleExtendedComponent acc_ext_component;

    public AtkAction(AccessibleContext accessibleContext) {
        this.ac = accessibleContext;
        this.acc_action = accessibleContext.getAccessibleAction();
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        if (accessibleComponent instanceof AccessibleExtendedComponent) {
            this.acc_ext_component = (AccessibleExtendedComponent)accessibleComponent;
        }
    }

    public boolean do_action(int n) {
        SwingUtilities.invokeLater(new ActionRunner(this.acc_action, n));
        return true;
    }

    public int get_n_actions() {
        return this.acc_action.getAccessibleActionCount();
    }

    public String get_description(int n) {
        String string = "<description>";
        return string;
    }

    public String get_name(int n) {
        String string = this.acc_action.getAccessibleActionDescription(n);
        if (string == null) {
            string = " ";
        }
        return string;
    }

    private String convertModString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String[] stringArray = string.split("\\+");
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "<" + stringArray[i] + ">";
        }
        return string2;
    }

    public String get_keybinding(int n) {
        AccessibleKeyBinding accessibleKeyBinding;
        if (n > 0) {
            return "";
        }
        if (this.acc_ext_component != null && (accessibleKeyBinding = this.acc_ext_component.getAccessibleKeyBinding()) != null && accessibleKeyBinding.getAccessibleKeyBindingCount() > 0) {
            int n2;
            String string = "";
            for (n2 = 0; n2 < accessibleKeyBinding.getAccessibleKeyBindingCount() && n2 < 3; ++n2) {
                String string2;
                KeyStroke[] keyStrokeArray;
                Object object = accessibleKeyBinding.getAccessibleKeyBinding(n2);
                if (n2 > 0) {
                    string = string + ";";
                }
                if (object instanceof KeyStroke) {
                    keyStrokeArray = (KeyStroke[])object;
                    String string3 = KeyEvent.getKeyModifiersText(keyStrokeArray.getModifiers());
                    string2 = KeyEvent.getKeyText(keyStrokeArray.getKeyCode());
                    if (string2 == null) continue;
                    if (string3 != null && string3.length() > 0) {
                        string = string + this.convertModString(string3) + string2;
                        continue;
                    }
                    string = string + string2;
                    continue;
                }
                if (!(object instanceof KeyStroke[])) continue;
                keyStrokeArray = (KeyStroke[])object;
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    string2 = KeyEvent.getKeyModifiersText(keyStrokeArray[i].getModifiers());
                    String string4 = KeyEvent.getKeyText(keyStrokeArray[i].getKeyCode());
                    if (i > 0) {
                        string = string + ":";
                    }
                    if (string4 == null) continue;
                    string = string2 != null && string2.length() > 0 ? string + this.convertModString(string2) + string4 : string + string4;
                }
            }
            if (n2 < 2) {
                string = string + ";";
            }
            if (n2 < 3) {
                string = string + ";";
            }
            return string;
        }
        return "";
    }

    private class ActionRunner
    implements Runnable {
        private AccessibleAction acc_action;
        private int index;

        public ActionRunner(AccessibleAction accessibleAction, int n) {
            this.acc_action = accessibleAction;
            this.index = n;
        }

        @Override
        public void run() {
            this.acc_action.doAccessibleAction(this.index);
        }
    }
}

