/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.NameNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NameClassPairEnumeration
implements NamingEnumeration {
    protected Enumeration nodes;
    protected DnsContext ctx;

    NameClassPairEnumeration(DnsContext ctx, Hashtable nodes) {
        this.ctx = ctx;
        this.nodes = nodes != null ? nodes.elements() : null;
    }

    @Override
    public void close() {
        this.nodes = null;
        this.ctx = null;
    }

    @Override
    public boolean hasMore() {
        boolean more;
        boolean bl = more = this.nodes != null && this.nodes.hasMoreElements();
        if (!more) {
            this.close();
        }
        return more;
    }

    public Object next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        NameNode nnode = (NameNode)this.nodes.nextElement();
        String className = nnode.isZoneCut() || nnode.getChildren() != null ? "javax.naming.directory.DirContext" : "java.lang.Object";
        String label = nnode.getLabel();
        Name compName = new DnsName().add(label);
        Name cname = new CompositeName().add(compName.toString());
        NameClassPair ncp = new NameClassPair(cname.toString(), className);
        ncp.setNameInNamespace(this.ctx.fullyQualify(cname).toString());
        return ncp;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException("javax.naming.NamingException was thrown: " + e.getMessage());
        }
    }
}

