/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class ActivationID
implements Serializable {
    private transient Activator activator;
    private transient UID uid = new UID();
    private static final long serialVersionUID = -4608673054848209235L;

    public ActivationID(Activator activator) {
        this.activator = activator;
    }

    public Remote activate(boolean force) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            MarshalledObject<? extends Remote> mobj = this.activator.activate(this, force);
            return mobj.get();
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UnmarshalException("activation failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new UnmarshalException("activation failed", e);
        }
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ActivationID) {
            ActivationID id = (ActivationID)obj;
            return this.uid.equals(id.uid) && this.activator.equals(id.activator);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        RemoteRef ref;
        out.writeObject(this.uid);
        if (this.activator instanceof RemoteObject) {
            ref = ((RemoteObject)((Object)this.activator)).getRef();
        } else if (Proxy.isProxyClass(this.activator.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(this.activator);
            if (!(handler instanceof RemoteObjectInvocationHandler)) {
                throw new InvalidObjectException("unexpected invocation handler");
            }
            ref = ((RemoteObjectInvocationHandler)handler).getRef();
        } else {
            throw new InvalidObjectException("unexpected activator type");
        }
        out.writeUTF(ref.getRefClass(out));
        ref.writeExternal(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uid = (UID)in.readObject();
        try {
            Class<RemoteRef> refClass = Class.forName("sun.rmi.server." + in.readUTF()).asSubclass(RemoteRef.class);
            RemoteRef ref = refClass.newInstance();
            ref.readExternal(in);
            this.activator = (Activator)Proxy.newProxyInstance(null, new Class[]{Activator.class}, new RemoteObjectInvocationHandler(ref));
        }
        catch (InstantiationException e) {
            throw (IOException)new InvalidObjectException("Unable to create remote reference").initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new InvalidObjectException("Unable to create remote reference").initCause(e);
        }
    }
}

