/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import sun.awt.image.IntegerComponentRaster;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.SpanIterator;

class OpaqueCopyAnyToArgb
extends Blit {
    OpaqueCopyAnyToArgb() {
        super(SurfaceType.Any, CompositeType.SrcNoEa, SurfaceType.IntArgb);
    }

    @Override
    public void Blit(SurfaceData src, SurfaceData dst, Composite comp, Region clip, int srcx, int srcy, int dstx, int dsty, int w, int h) {
        Raster srcRast = src.getRaster(srcx, srcy, w, h);
        ColorModel srcCM = src.getColorModel();
        Raster dstRast = dst.getRaster(dstx, dsty, w, h);
        IntegerComponentRaster icr = (IntegerComponentRaster)dstRast;
        int[] dstPix = icr.getDataStorage();
        Region roi = CustomComponent.getRegionOfInterest(src, dst, clip, srcx, srcy, dstx, dsty, w, h);
        SpanIterator si = roi.getSpanIterator();
        Object srcPix = null;
        int dstScan = icr.getScanlineStride();
        srcx -= dstx;
        srcy -= dsty;
        int[] span = new int[4];
        while (si.nextSpan(span)) {
            int rowoff = icr.getDataOffset(0) + span[1] * dstScan + span[0];
            for (int y = span[1]; y < span[3]; ++y) {
                int off = rowoff;
                for (int x = span[0]; x < span[2]; ++x) {
                    srcPix = srcRast.getDataElements(x + srcx, y + srcy, srcPix);
                    dstPix[off++] = srcCM.getRGB(srcPix);
                }
                rowoff += dstScan;
            }
        }
        icr.markDirty();
    }
}

