/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static Map<String, String[]> disabledAlgorithmsMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, KeySizeConstraints> keySizeConstraintsMap = Collections.synchronizedMap(new HashMap());
    private final String[] disabledAlgorithms;
    private final KeySizeConstraints keySizeConstraints;

    public DisabledAlgorithmConstraints(String propertyName) {
        this(propertyName, new AlgorithmDecomposer());
    }

    public DisabledAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.disabledAlgorithms = DisabledAlgorithmConstraints.getAlgorithms(disabledAlgorithmsMap, propertyName);
        this.keySizeConstraints = DisabledAlgorithmConstraints.getKeySizeConstraints(this.disabledAlgorithms, propertyName);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        if (primitives == null || primitives.isEmpty()) {
            throw new IllegalArgumentException("No cryptographic primitive specified");
        }
        return DisabledAlgorithmConstraints.checkAlgorithm(this.disabledAlgorithms, algorithm, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return this.checkConstraints(primitives, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        return this.checkConstraints(primitives, algorithm, key, parameters);
    }

    private boolean checkConstraints(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
        if (algorithm != null && algorithm.length() != 0 && !this.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (!this.permits(primitives, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeySizeConstraints getKeySizeConstraints(String[] disabledAlgorithms, String propertyName) {
        Map<String, KeySizeConstraints> map = keySizeConstraintsMap;
        synchronized (map) {
            if (!keySizeConstraintsMap.containsKey(propertyName)) {
                KeySizeConstraints keySizeConstraints = new KeySizeConstraints(disabledAlgorithms);
                keySizeConstraintsMap.put(propertyName, keySizeConstraints);
            }
            return keySizeConstraintsMap.get(propertyName);
        }
    }

    private static class KeySizeConstraint {
        private int minSize;
        private int maxSize;
        private int prohibitedSize = -1;

        public KeySizeConstraint(Operator operator, int length) {
            switch (operator) {
                case EQ: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = length;
                    break;
                }
                case NE: {
                    this.minSize = length;
                    this.maxSize = length;
                    break;
                }
                case LT: {
                    this.minSize = length;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case LE: {
                    this.minSize = length + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case GT: {
                    this.minSize = 0;
                    this.maxSize = length;
                    break;
                }
                case GE: {
                    this.minSize = 0;
                    this.maxSize = length > 1 ? length - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            int size = KeyUtil.getKeySize(key);
            if (size == 0) {
                return true;
            }
            if (size > 0) {
                return size < this.minSize || size > this.maxSize || this.prohibitedSize == size;
            }
            return false;
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String s) {
                switch (s) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw new IllegalArgumentException(s + " is not a legal Operator");
            }
        }
    }

    private static class KeySizeConstraints {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap = Collections.synchronizedMap(new HashMap());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] restrictions) {
            for (String restriction : restrictions) {
                Matcher matcher;
                if (restriction == null || restriction.isEmpty() || !(matcher = pattern.matcher(restriction)).matches()) continue;
                String algorithm = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int length = Integer.parseInt(matcher.group(3));
                algorithm = algorithm.toLowerCase(Locale.ENGLISH);
                Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
                synchronized (map) {
                    if (!this.constraintsMap.containsKey(algorithm)) {
                        this.constraintsMap.put(algorithm, new HashSet());
                    }
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    KeySizeConstraint constraint = new KeySizeConstraint(operator, length);
                    constraintSet.add(constraint);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String algorithm = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Map<String, Set<KeySizeConstraint>> map = this.constraintsMap;
            synchronized (map) {
                if (this.constraintsMap.containsKey(algorithm)) {
                    Set<KeySizeConstraint> constraintSet = this.constraintsMap.get(algorithm);
                    for (KeySizeConstraint constraint : constraintSet) {
                        if (!constraint.disables(key)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

