/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.Config;
import sun.security.pkcs11.KeyCache;
import sun.security.pkcs11.P11DHKeyFactory;
import sun.security.pkcs11.P11DSAKeyFactory;
import sun.security.pkcs11.P11ECKeyFactory;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11KeyStore;
import sun.security.pkcs11.P11RSAKeyFactory;
import sun.security.pkcs11.P11SecureRandom;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SessionManager;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.TemplateManager;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class Token
implements Serializable {
    private static final long serialVersionUID = 2541527649100571747L;
    private static final long CHECK_INTERVAL = 50L;
    final SunPKCS11 provider;
    final PKCS11 p11;
    final Config config;
    final CK_TOKEN_INFO tokenInfo;
    final SessionManager sessionManager;
    private final TemplateManager templateManager;
    final boolean explicitCancel;
    final KeyCache secretCache;
    final KeyCache privateCache;
    private volatile P11KeyFactory rsaFactory;
    private volatile P11KeyFactory dsaFactory;
    private volatile P11KeyFactory dhFactory;
    private volatile P11KeyFactory ecFactory;
    private final Map<Long, CK_MECHANISM_INFO> mechInfoMap;
    private volatile P11SecureRandom secureRandom;
    private volatile P11KeyStore keyStore;
    private final boolean removable;
    private volatile boolean valid;
    private long lastPresentCheck;
    private byte[] tokenId;
    private boolean writeProtected;
    private volatile boolean loggedIn;
    private long lastLoginCheck;
    private static final Object CHECK_LOCK = new Object();
    private static final CK_MECHANISM_INFO INVALID_MECH = new CK_MECHANISM_INFO(0L, 0L, 0L);
    private Boolean supportsRawSecretKeyImport;
    private static final List<Reference<Token>> serializedTokens = new ArrayList<Reference<Token>>();

    Token(SunPKCS11 provider) throws PKCS11Exception {
        SessionManager sessionManager;
        this.provider = provider;
        this.removable = provider.removable;
        this.valid = true;
        this.p11 = provider.p11;
        this.config = provider.config;
        this.tokenInfo = this.p11.C_GetTokenInfo(provider.slotID);
        this.writeProtected = (this.tokenInfo.flags & 2L) != 0L;
        try {
            sessionManager = new SessionManager(this);
            Session s = sessionManager.getOpSession();
            sessionManager.releaseSession(s);
        }
        catch (PKCS11Exception e) {
            if (this.writeProtected) {
                throw e;
            }
            this.writeProtected = true;
            sessionManager = new SessionManager(this);
            Session s = sessionManager.getOpSession();
            sessionManager.releaseSession(s);
        }
        this.sessionManager = sessionManager;
        this.secretCache = new KeyCache();
        this.privateCache = new KeyCache();
        this.templateManager = this.config.getTemplateManager();
        this.explicitCancel = this.config.getExplicitCancel();
        this.mechInfoMap = Collections.synchronizedMap(new HashMap(10));
    }

    boolean isWriteProtected() {
        return this.writeProtected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean supportsRawSecretKeyImport() {
        if (this.supportsRawSecretKeyImport == null) {
            SecureRandom random = JCAUtil.getSecureRandom();
            byte[] encoded = new byte[48];
            random.nextBytes(encoded);
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, 16L), new CK_ATTRIBUTE(17L, encoded)};
            Session session = null;
            try {
                attributes = this.getAttributes("import", 4L, 16L, attributes);
                session = this.getObjSession();
                long keyID = this.p11.C_CreateObject(session.id(), attributes);
                this.supportsRawSecretKeyImport = Boolean.TRUE;
                this.releaseSession(session);
            }
            catch (PKCS11Exception e) {
                this.supportsRawSecretKeyImport = Boolean.FALSE;
            }
            finally {
                this.releaseSession(session);
            }
        }
        return this.supportsRawSecretKeyImport;
    }

    boolean isLoggedIn(Session session) throws PKCS11Exception {
        boolean loggedIn = this.loggedIn;
        long time = System.currentTimeMillis();
        if (time - this.lastLoginCheck > 50L) {
            loggedIn = this.isLoggedInNow(session);
            this.lastLoginCheck = time;
        }
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggedInNow(Session session) throws PKCS11Exception {
        boolean allocSession = session == null;
        try {
            boolean loggedIn;
            if (allocSession) {
                session = this.getOpSession();
            }
            CK_SESSION_INFO info = this.p11.C_GetSessionInfo(session.id());
            this.loggedIn = loggedIn = info.state == 1L || info.state == 3L;
            boolean bl = loggedIn;
            return bl;
        }
        finally {
            if (allocSession) {
                this.releaseSession(session);
            }
        }
    }

    void ensureLoggedIn(Session session) throws PKCS11Exception, LoginException {
        if (!this.isLoggedIn(session)) {
            this.provider.login(null, null);
        }
    }

    boolean isValid() {
        if (!this.removable) {
            return true;
        }
        return this.valid;
    }

    void ensureValid() {
        if (!this.isValid()) {
            throw new ProviderException("Token has been removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPresent(long sessionID) {
        if (!this.removable) {
            return true;
        }
        if (!this.valid) {
            return false;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastPresentCheck >= 50L) {
            Object object = CHECK_LOCK;
            synchronized (object) {
                if (time - this.lastPresentCheck >= 50L) {
                    boolean ok = false;
                    try {
                        CK_SLOT_INFO slotInfo = this.provider.p11.C_GetSlotInfo(this.provider.slotID);
                        if ((slotInfo.flags & 1L) != 0L) {
                            CK_SESSION_INFO sessInfo = this.provider.p11.C_GetSessionInfo(sessionID);
                            ok = true;
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        // empty catch block
                    }
                    this.valid = ok;
                    this.lastPresentCheck = System.currentTimeMillis();
                    if (!ok) {
                        this.destroy();
                    }
                }
            }
        }
        return this.valid;
    }

    void destroy() {
        this.valid = false;
        this.provider.uninitToken(this);
    }

    Session getObjSession() throws PKCS11Exception {
        return this.sessionManager.getObjSession();
    }

    Session getOpSession() throws PKCS11Exception {
        return this.sessionManager.getOpSession();
    }

    Session releaseSession(Session session) {
        return this.sessionManager.releaseSession(session);
    }

    Session killSession(Session session) {
        return this.sessionManager.killSession(session);
    }

    CK_ATTRIBUTE[] getAttributes(String op, long type, long alg, CK_ATTRIBUTE[] attrs) throws PKCS11Exception {
        CK_ATTRIBUTE[] newAttrs;
        for (CK_ATTRIBUTE attr : newAttrs = this.templateManager.getAttributes(op, type, alg, attrs)) {
            if (attr.type != 1L) continue;
            if (!attr.getBoolean()) break;
            try {
                this.ensureLoggedIn(null);
                break;
            }
            catch (LoginException e) {
                throw new ProviderException("Login failed", e);
            }
        }
        return newAttrs;
    }

    P11KeyFactory getKeyFactory(String algorithm) {
        P11KeyFactory f;
        if (algorithm.equals("RSA")) {
            f = this.rsaFactory;
            if (f == null) {
                this.rsaFactory = f = new P11RSAKeyFactory(this, algorithm);
            }
        } else if (algorithm.equals("DSA")) {
            f = this.dsaFactory;
            if (f == null) {
                this.dsaFactory = f = new P11DSAKeyFactory(this, algorithm);
            }
        } else if (algorithm.equals("DH")) {
            f = this.dhFactory;
            if (f == null) {
                this.dhFactory = f = new P11DHKeyFactory(this, algorithm);
            }
        } else if (algorithm.equals("EC")) {
            f = this.ecFactory;
            if (f == null) {
                this.ecFactory = f = new P11ECKeyFactory(this, algorithm);
            }
        } else {
            throw new ProviderException("Unknown algorithm " + algorithm);
        }
        return f;
    }

    P11SecureRandom getRandom() {
        if (this.secureRandom == null) {
            this.secureRandom = new P11SecureRandom(this);
        }
        return this.secureRandom;
    }

    P11KeyStore getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = new P11KeyStore(this);
        }
        return this.keyStore;
    }

    CK_MECHANISM_INFO getMechanismInfo(long mechanism) throws PKCS11Exception {
        CK_MECHANISM_INFO result = this.mechInfoMap.get(mechanism);
        if (result == null) {
            try {
                result = this.p11.C_GetMechanismInfo(this.provider.slotID, mechanism);
                this.mechInfoMap.put(mechanism, result);
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() != 112L) {
                    throw e;
                }
                this.mechInfoMap.put(mechanism, INVALID_MECH);
            }
        } else if (result == INVALID_MECH) {
            result = null;
        }
        return result;
    }

    private synchronized byte[] getTokenId() {
        if (this.tokenId == null) {
            SecureRandom random = JCAUtil.getSecureRandom();
            this.tokenId = new byte[20];
            random.nextBytes(this.tokenId);
            serializedTokens.add(new WeakReference<Token>(this));
        }
        return this.tokenId;
    }

    private Object writeReplace() throws ObjectStreamException {
        if (!this.isValid()) {
            throw new NotSerializableException("Token has been removed");
        }
        return new TokenRep(this);
    }

    private static class TokenRep
    implements Serializable {
        private static final long serialVersionUID = 3503721168218219807L;
        private final byte[] tokenId;

        TokenRep(Token token) {
            this.tokenId = token.getTokenId();
        }

        private Object readResolve() throws ObjectStreamException {
            for (Reference tokenRef : serializedTokens) {
                Token token = (Token)tokenRef.get();
                if (token == null || !token.isValid() || !Arrays.equals(token.getTokenId(), this.tokenId)) continue;
                return token;
            }
            throw new NotSerializableException("Could not find token");
        }
    }
}

