/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.SuppressForbidden;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.InnerHitsQueryParserHelper;
import org.elasticsearch.index.query.support.XContentStructure;
import org.elasticsearch.index.search.child.ChildrenConstantScoreQuery;
import org.elasticsearch.index.search.child.ChildrenQuery;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsSubSearchContext;

@SuppressForbidden(reason="Old p/c queries still use filters")
public class HasChildQueryParser
implements QueryParser {
    public static final String NAME = "has_child";
    private static final ParseField QUERY_FIELD = new ParseField("query", "filter");
    private static final ParseField SCORE_MODE = new ParseField("score_mode", "score_type");
    private final InnerHitsQueryParserHelper innerHitsQueryParserHelper;

    @Inject
    public HasChildQueryParser(InnerHitsQueryParserHelper innerHitsQueryParserHelper) {
        this.innerHitsQueryParserHelper = innerHitsQueryParserHelper;
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean queryFound = false;
        float boost = 1.0f;
        String childType = null;
        ScoreType scoreType = ScoreType.NONE;
        int minChildren = 0;
        int maxChildren = 0;
        int shortCircuitParentDocSet = 8192;
        String queryName = null;
        InnerHitsSubSearchContext innerHits = null;
        String currentFieldName = null;
        XContentStructure.InnerQuery iq = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    String[] stringArray;
                    if (childType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = childType;
                    }
                    iq = new XContentStructure.InnerQuery(parseContext, stringArray);
                    queryFound = true;
                    continue;
                }
                if ("inner_hits".equals(currentFieldName)) {
                    innerHits = this.innerHitsQueryParserHelper.parse(parseContext);
                    continue;
                }
                throw new QueryParsingException(parseContext, "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "child_type".equals(currentFieldName) || "childType".equals(currentFieldName)) {
                childType = parser.text();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, SCORE_MODE)) {
                scoreType = ScoreType.fromString(parser.text());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("min_children".equals(currentFieldName) || "minChildren".equals(currentFieldName)) {
                minChildren = parser.intValue(true);
                continue;
            }
            if ("max_children".equals(currentFieldName) || "maxChildren".equals(currentFieldName)) {
                maxChildren = parser.intValue(true);
                continue;
            }
            if ("short_circuit_cutoff".equals(currentFieldName)) {
                shortCircuitParentDocSet = parser.intValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[has_child] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext, "[has_child] requires 'query' field", new Object[0]);
        }
        if (childType == null) {
            throw new QueryParsingException(parseContext, "[has_child] requires 'type' field", new Object[0]);
        }
        Query innerQuery = iq.asQuery(childType);
        if (innerQuery == null) {
            return null;
        }
        innerQuery.setBoost(boost);
        DocumentMapper childDocMapper = parseContext.mapperService().documentMapper(childType);
        if (childDocMapper == null) {
            throw new QueryParsingException(parseContext, "[has_child] No mapping for for type [" + childType + "]", new Object[0]);
        }
        ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
        if (!parentFieldMapper.active()) {
            throw new QueryParsingException(parseContext, "[has_child] _parent field has no parent type configured", new Object[0]);
        }
        if (innerHits != null) {
            ParsedQuery parsedQuery = new ParsedQuery(innerQuery, parseContext.copyNamedQueries());
            InnerHitsContext.ParentChildInnerHits parentChildInnerHits = new InnerHitsContext.ParentChildInnerHits(innerHits.getSubSearchContext(), parsedQuery, null, parseContext.mapperService(), childDocMapper);
            String name = innerHits.getName() != null ? innerHits.getName() : childType;
            parseContext.addInnerHits(name, parentChildInnerHits);
        }
        String parentType = parentFieldMapper.type();
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryParsingException(parseContext, "[has_child]  Type [" + childType + "] points to a non existent parent type [" + parentType + "]", new Object[0]);
        }
        if (maxChildren > 0 && maxChildren < minChildren) {
            throw new QueryParsingException(parseContext, "[has_child] 'max_children' is less than 'min_children'", new Object[0]);
        }
        BitSetProducer nonNestedDocsFilter = null;
        if (parentDocMapper.hasNestedObjects()) {
            nonNestedDocsFilter = parseContext.bitsetFilter(Queries.newNonNestedFilter());
        }
        innerQuery = Queries.filtered(innerQuery, childDocMapper.typeFilter());
        ParentChildIndexFieldData parentChildIndexFieldData = (ParentChildIndexFieldData)parseContext.getForField(parentFieldMapper.fieldType());
        if (parseContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
            query = HasChildQueryParser.joinUtilHelper(parentType, parentChildIndexFieldData, parentDocMapper.typeFilter(), scoreType, innerQuery, minChildren, maxChildren);
        } else {
            QueryWrapperFilter parentFilter = new QueryWrapperFilter(parentDocMapper.typeFilter());
            query = minChildren > 1 || maxChildren > 0 || scoreType != ScoreType.NONE ? new ChildrenQuery(parentChildIndexFieldData, parentType, childType, (Filter)parentFilter, innerQuery, scoreType, minChildren, maxChildren, shortCircuitParentDocSet, nonNestedDocsFilter) : new ChildrenConstantScoreQuery(parentChildIndexFieldData, innerQuery, parentType, childType, (Filter)parentFilter, shortCircuitParentDocSet, nonNestedDocsFilter);
        }
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        query.setBoost(boost);
        return query;
    }

    public static Query joinUtilHelper(String parentType, ParentChildIndexFieldData parentChildIndexFieldData, Query toQuery, ScoreType scoreType, Query innerQuery, int minChildren, int maxChildren) throws IOException {
        ScoreMode scoreMode;
        switch (scoreType) {
            case NONE: {
                scoreMode = ScoreMode.None;
                break;
            }
            case MIN: {
                scoreMode = ScoreMode.Min;
                break;
            }
            case MAX: {
                scoreMode = ScoreMode.Max;
                break;
            }
            case SUM: {
                scoreMode = ScoreMode.Total;
                break;
            }
            case AVG: {
                scoreMode = ScoreMode.Avg;
                break;
            }
            default: {
                throw new UnsupportedOperationException("score type [" + (Object)((Object)scoreType) + "] not supported");
            }
        }
        if (maxChildren == 0) {
            maxChildren = Integer.MAX_VALUE;
        }
        return new LateParsingQuery(toQuery, innerQuery, minChildren, maxChildren, parentType, scoreMode, parentChildIndexFieldData);
    }

    static final class LateParsingQuery
    extends Query {
        private final Query toQuery;
        private final Query innerQuery;
        private final int minChildren;
        private final int maxChildren;
        private final String parentType;
        private final ScoreMode scoreMode;
        private final ParentChildIndexFieldData parentChildIndexFieldData;
        private final Object identity = new Object();

        LateParsingQuery(Query toQuery, Query innerQuery, int minChildren, int maxChildren, String parentType, ScoreMode scoreMode, ParentChildIndexFieldData parentChildIndexFieldData) {
            this.toQuery = toQuery;
            this.innerQuery = innerQuery;
            this.minChildren = minChildren;
            this.maxChildren = maxChildren;
            this.parentType = parentType;
            this.scoreMode = scoreMode;
            this.parentChildIndexFieldData = parentChildIndexFieldData;
        }

        public Query rewrite(IndexReader reader) throws IOException {
            if (this.getBoost() != 1.0f) {
                return super.rewrite(reader);
            }
            if (reader instanceof DirectoryReader) {
                String joinField = ParentFieldMapper.joinField(this.parentType);
                IndexSearcher indexSearcher = new IndexSearcher(reader);
                indexSearcher.setQueryCache(null);
                IndexParentChildFieldData indexParentChildFieldData = this.parentChildIndexFieldData.loadGlobal((DirectoryReader)reader);
                MultiDocValues.OrdinalMap ordinalMap = ParentChildIndexFieldData.getOrdinalMap(indexParentChildFieldData, this.parentType);
                return JoinUtil.createJoinQuery((String)joinField, (Query)this.innerQuery, (Query)this.toQuery, (IndexSearcher)indexSearcher, (ScoreMode)this.scoreMode, (MultiDocValues.OrdinalMap)ordinalMap, (int)this.minChildren, (int)this.maxChildren);
            }
            if (reader.leaves().isEmpty() && reader.numDocs() == 0) {
                return new MatchNoDocsQuery();
            }
            throw new IllegalStateException("can't load global ordinals for reader of type: " + reader.getClass() + " must be a DirectoryReader");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LateParsingQuery that = (LateParsingQuery)((Object)o);
            return this.identity.equals(that.identity);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.identity.hashCode();
            return result;
        }

        public String toString(String s) {
            return "LateParsingQuery {parentType=" + this.parentType + "}";
        }
    }
}

