/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

final class ExactPhraseScorer
extends Scorer {
    private final ConjunctionDISI conjunction;
    private final PostingsAndPosition[] postings;
    private int freq;
    private final Similarity.SimScorer docScorer;
    private final boolean needsScores;
    private float matchCost;

    ExactPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postings, Similarity.SimScorer docScorer, boolean needsScores, float matchCost) throws IOException {
        super(weight);
        this.docScorer = docScorer;
        this.needsScores = needsScores;
        ArrayList<PostingsEnum> iterators = new ArrayList<PostingsEnum>();
        ArrayList<PostingsAndPosition> postingsAndPositions = new ArrayList<PostingsAndPosition>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            iterators.add(posting.postings);
            postingsAndPositions.add(new PostingsAndPosition(posting.postings, posting.position));
        }
        this.conjunction = ConjunctionDISI.intersect(iterators);
        this.postings = postingsAndPositions.toArray(new PostingsAndPosition[postingsAndPositions.size()]);
        this.matchCost = matchCost;
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return new TwoPhaseIterator(this.conjunction){

            @Override
            public boolean matches() throws IOException {
                return ExactPhraseScorer.this.phraseFreq() > 0;
            }

            @Override
            public float matchCost() {
                return ExactPhraseScorer.this.matchCost;
            }
        };
    }

    private int doNext(int doc) throws IOException {
        while (doc != Integer.MAX_VALUE && this.phraseFreq() <= 0) {
            doc = this.conjunction.nextDoc();
        }
        return doc;
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.conjunction.nextDoc());
    }

    @Override
    public int advance(int target) throws IOException {
        return this.doNext(this.conjunction.advance(target));
    }

    public String toString() {
        return "ExactPhraseScorer(" + this.weight + ")";
    }

    @Override
    public int freq() {
        return this.freq;
    }

    @Override
    public int docID() {
        return this.conjunction.docID();
    }

    @Override
    public float score() {
        return this.docScorer.score(this.docID(), this.freq);
    }

    private static boolean advancePosition(PostingsAndPosition posting, int target) throws IOException {
        while (posting.pos < target) {
            if (posting.upTo == posting.freq) {
                return false;
            }
            posting.pos = posting.postings.nextPosition();
            posting.upTo += 1;
        }
        return true;
    }

    private int phraseFreq() throws IOException {
        PostingsAndPosition[] postings;
        for (PostingsAndPosition posting : postings = this.postings) {
            posting.freq = posting.postings.freq();
            posting.pos = posting.postings.nextPosition();
            posting.upTo = 1;
        }
        int freq = 0;
        PostingsAndPosition lead = postings[0];
        block1: while (true) {
            int phrasePos = lead.pos - lead.offset;
            for (int j = 1; j < postings.length; ++j) {
                PostingsAndPosition posting = postings[j];
                int expectedPos = phrasePos + posting.offset;
                if (!ExactPhraseScorer.advancePosition(posting, expectedPos)) break block1;
                if (posting.pos == expectedPos) continue;
                if (!ExactPhraseScorer.advancePosition(lead, posting.pos - posting.offset + lead.offset)) break block1;
                continue block1;
            }
            ++freq;
            if (!this.needsScores || lead.upTo == lead.freq) break;
            lead.pos = lead.postings.nextPosition();
            lead.upTo += 1;
        }
        this.freq = freq;
        return this.freq;
    }

    @Override
    public long cost() {
        return this.conjunction.cost();
    }

    private static class PostingsAndPosition {
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(PostingsEnum postings, int offset) {
            this.postings = postings;
            this.offset = offset;
        }
    }
}

