'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Redistribution and use in source and binary forms, with or without
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       modification, are permitted provided that the following conditions are met:
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         * Redistributions of source code must retain the above copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           notice, this list of conditions and the following disclaimer.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         * Redistributions in binary form must reproduce the above copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           notice, this list of conditions and the following disclaimer in the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           documentation and/or other materials provided with the distribution.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     */

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _es6WeakMap = require('es6-weak-map');

var _es6WeakMap2 = _interopRequireDefault(_es6WeakMap);

var _scope = require('./scope');

var _scope2 = _interopRequireDefault(_scope);

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * @class ScopeManager
 */

var ScopeManager = function () {
    function ScopeManager(options) {
        _classCallCheck(this, ScopeManager);

        this.scopes = [];
        this.globalScope = null;
        this.__nodeToScope = new _es6WeakMap2.default();
        this.__currentScope = null;
        this.__options = options;
        this.__declaredVariables = new _es6WeakMap2.default();
    }

    _createClass(ScopeManager, [{
        key: '__useDirective',
        value: function __useDirective() {
            return this.__options.directive;
        }
    }, {
        key: '__isOptimistic',
        value: function __isOptimistic() {
            return this.__options.optimistic;
        }
    }, {
        key: '__ignoreEval',
        value: function __ignoreEval() {
            return this.__options.ignoreEval;
        }
    }, {
        key: '__isNodejsScope',
        value: function __isNodejsScope() {
            return this.__options.nodejsScope;
        }
    }, {
        key: 'isModule',
        value: function isModule() {
            return this.__options.sourceType === 'module';
        }
    }, {
        key: 'isImpliedStrict',
        value: function isImpliedStrict() {
            return this.__options.impliedStrict;
        }
    }, {
        key: 'isStrictModeSupported',
        value: function isStrictModeSupported() {
            return this.__options.ecmaVersion >= 5;
        }

        // Returns appropriate scope for this node.

    }, {
        key: '__get',
        value: function __get(node) {
            return this.__nodeToScope.get(node);
        }

        /**
         * Get variables that are declared by the node.
         *
         * "are declared by the node" means the node is same as `Variable.defs[].node` or `Variable.defs[].parent`.
         * If the node declares nothing, this method returns an empty array.
         * CAUTION: This API is experimental. See https://github.com/estools/escope/pull/69 for more details.
         *
         * @param {Esprima.Node} node - a node to get.
         * @returns {Variable[]} variables that declared by the node.
         */

    }, {
        key: 'getDeclaredVariables',
        value: function getDeclaredVariables(node) {
            return this.__declaredVariables.get(node) || [];
        }

        /**
         * acquire scope from node.
         * @method ScopeManager#acquire
         * @param {Esprima.Node} node - node for the acquired scope.
         * @param {boolean=} inner - look up the most inner scope, default value is false.
         * @return {Scope?}
         */

    }, {
        key: 'acquire',
        value: function acquire(node, inner) {
            var scopes, scope, i, iz;

            function predicate(scope) {
                if (scope.type === 'function' && scope.functionExpressionScope) {
                    return false;
                }
                if (scope.type === 'TDZ') {
                    return false;
                }
                return true;
            }

            scopes = this.__get(node);
            if (!scopes || scopes.length === 0) {
                return null;
            }

            // Heuristic selection from all scopes.
            // If you would like to get all scopes, please use ScopeManager#acquireAll.
            if (scopes.length === 1) {
                return scopes[0];
            }

            if (inner) {
                for (i = scopes.length - 1; i >= 0; --i) {
                    scope = scopes[i];
                    if (predicate(scope)) {
                        return scope;
                    }
                }
            } else {
                for (i = 0, iz = scopes.length; i < iz; ++i) {
                    scope = scopes[i];
                    if (predicate(scope)) {
                        return scope;
                    }
                }
            }

            return null;
        }

        /**
         * acquire all scopes from node.
         * @method ScopeManager#acquireAll
         * @param {Esprima.Node} node - node for the acquired scope.
         * @return {Scope[]?}
         */

    }, {
        key: 'acquireAll',
        value: function acquireAll(node) {
            return this.__get(node);
        }

        /**
         * release the node.
         * @method ScopeManager#release
         * @param {Esprima.Node} node - releasing node.
         * @param {boolean=} inner - look up the most inner scope, default value is false.
         * @return {Scope?} upper scope for the node.
         */

    }, {
        key: 'release',
        value: function release(node, inner) {
            var scopes, scope;
            scopes = this.__get(node);
            if (scopes && scopes.length) {
                scope = scopes[0].upper;
                if (!scope) {
                    return null;
                }
                return this.acquire(scope.block, inner);
            }
            return null;
        }
    }, {
        key: 'attach',
        value: function attach() {}
    }, {
        key: 'detach',
        value: function detach() {}
    }, {
        key: '__nestScope',
        value: function __nestScope(scope) {
            if (scope instanceof _scope.GlobalScope) {
                (0, _assert2.default)(this.__currentScope === null);
                this.globalScope = scope;
            }
            this.__currentScope = scope;
            return scope;
        }
    }, {
        key: '__nestGlobalScope',
        value: function __nestGlobalScope(node) {
            return this.__nestScope(new _scope.GlobalScope(this, node));
        }
    }, {
        key: '__nestBlockScope',
        value: function __nestBlockScope(node, isMethodDefinition) {
            return this.__nestScope(new _scope.BlockScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestFunctionScope',
        value: function __nestFunctionScope(node, isMethodDefinition) {
            return this.__nestScope(new _scope.FunctionScope(this, this.__currentScope, node, isMethodDefinition));
        }
    }, {
        key: '__nestForScope',
        value: function __nestForScope(node) {
            return this.__nestScope(new _scope.ForScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestCatchScope',
        value: function __nestCatchScope(node) {
            return this.__nestScope(new _scope.CatchScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestWithScope',
        value: function __nestWithScope(node) {
            return this.__nestScope(new _scope.WithScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestClassScope',
        value: function __nestClassScope(node) {
            return this.__nestScope(new _scope.ClassScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestSwitchScope',
        value: function __nestSwitchScope(node) {
            return this.__nestScope(new _scope.SwitchScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestModuleScope',
        value: function __nestModuleScope(node) {
            return this.__nestScope(new _scope.ModuleScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestTDZScope',
        value: function __nestTDZScope(node) {
            return this.__nestScope(new _scope.TDZScope(this, this.__currentScope, node));
        }
    }, {
        key: '__nestFunctionExpressionNameScope',
        value: function __nestFunctionExpressionNameScope(node) {
            return this.__nestScope(new _scope.FunctionExpressionNameScope(this, this.__currentScope, node));
        }
    }, {
        key: '__isES6',
        value: function __isES6() {
            return this.__options.ecmaVersion >= 6;
        }
    }]);

    return ScopeManager;
}();

/* vim: set sw=4 ts=4 et tw=80 : */

exports.default = ScopeManager;
//# sourceMappingURL=data:application/json;base64,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
