/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.read;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadBinaryStringNode
extends PackNode {
    final boolean readToEnd;
    final boolean readToNull;
    final int count;
    final boolean trimTrailingSpaces;
    final boolean trimTrailingNulls;
    final boolean trimToFirstNull;

    public ReadBinaryStringNode(RubyContext context, boolean readToEnd, boolean readToNull, int count, boolean trimTrailingSpaces, boolean trimTrailingNulls, boolean trimToFirstNull) {
        super(context);
        this.readToEnd = readToEnd;
        this.readToNull = readToNull;
        this.count = count;
        this.trimTrailingSpaces = trimTrailingSpaces;
        this.trimTrailingNulls = trimTrailingNulls;
        this.trimToFirstNull = trimToFirstNull;
    }

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        CompilerDirectives.transferToInterpreter();
        this.advanceSourcePosition(frame, this.count);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int firstNull;
        int usedLength;
        int length;
        int start = this.getSourcePosition(frame);
        if (this.readToEnd) {
            length = 0;
            while (start + length < this.getSourceLength(frame) && (!this.readToNull || start + length < this.getSourceLength(frame) && source[start + length] != 0)) {
                ++length;
            }
            if (start + length < this.getSourceLength(frame) && source[start + length] == 0) {
                ++length;
            }
        } else if (this.readToNull) {
            for (length = 0; start + length < this.getSourceLength(frame) && length < this.count && (!this.readToNull || start + length < this.getSourceLength(frame) && source[start + length] != 0); ++length) {
            }
            if (start + length < this.getSourceLength(frame) && source[start + length] == 0) {
                ++length;
            }
        } else {
            length = this.count;
            if (start + length >= this.getSourceLength(frame)) {
                length = this.getSourceLength(frame) - start;
            }
        }
        for (usedLength = length; usedLength > 0 && (this.trimTrailingSpaces && source[start + usedLength - 1] == 32 || this.trimTrailingNulls && source[start + usedLength - 1] == 0); --usedLength) {
        }
        ByteList result = new ByteList(source, start, usedLength, true);
        if (this.trimToFirstNull && (firstNull = result.indexOf(0)) != -1 && this.trimTrailingNulls) {
            result.realSize(firstNull);
        }
        this.setSourcePosition(frame, start + length);
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), result, 0, null);
    }
}

