/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class EncodingPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends RubiniusPrimitiveNode {
        public EncodingGetObjectEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject encodingGetObjectEncodingString(DynamicObject string) {
            return EncodingNodes.getEncoding(StringOperations.getByteList(string).getEncoding());
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public DynamicObject encodingGetObjectEncodingSymbol(DynamicObject symbol) {
            return EncodingNodes.getEncoding(Layouts.SYMBOL.getByteList(symbol).getEncoding());
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject encodingGetObjectEncoding(DynamicObject encoding) {
            return encoding;
        }

        @Specialization(guards={"isRubyRegexp(regexp)"})
        public DynamicObject encodingGetObjectEncodingRegexp(DynamicObject regexp) {
            return EncodingNodes.getEncoding(Layouts.REGEXP.getSource(regexp).getEncoding());
        }

        @Specialization(guards={"!isRubyString(object)", "!isRubySymbol(object)", "!isRubyEncoding(object)", "!isRubyRegexp(object)"})
        public DynamicObject encodingGetObjectEncodingNil(DynamicObject object) {
            return this.nil();
        }
    }
}

