/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.LocaleKeyValueItem;
import org.pdfsam.ui.dashboard.preference.PreferenceComboBox;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;

@Named
class PreferenceAppearencePane
extends GridPane {
    @Inject
    public PreferenceAppearencePane(@Named(value="localeCombo") PreferenceComboBox<LocaleKeyValueItem> localeCombo, @Named(value="themeCombo") PreferenceComboBox<KeyStringValueItem<String>> themeCombo, @Named(value="startupModuleCombo") PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo) {
        I18nContext i18n = DefaultI18nContext.getInstance();
        this.add((Node)new Label(i18n.i18n("Language:")), 0, 0);
        for (Locale current : DefaultI18nContext.SUPPORTED_LOCALES) {
            localeCombo.getItems().add((Object)new LocaleKeyValueItem(current));
        }
        localeCombo.setValue(new LocaleKeyValueItem(Locale.getDefault()));
        localeCombo.valueProperty().addListener((observable, oldValue, newValue) -> StaticStudio.eventStudio().broadcast(new SetLocaleEvent(newValue.getKey())));
        localeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(localeCombo, (Boolean)true);
        this.add((Node)localeCombo, 1, 0);
        this.add((Node)HelpUtils.helpIcon(i18n.i18n("Set your preferred language (restart needed)")), 2, 0);
        this.add((Node)new Label(i18n.i18n("Theme:")), 0, 1);
        themeCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(themeCombo, (Boolean)true);
        this.add((Node)themeCombo, 1, 1);
        this.add((Node)HelpUtils.helpIcon(i18n.i18n("Set your preferred theme (restart needed)")), 2, 1);
        this.add((Node)new Label(i18n.i18n("Startup module:")), 0, 2);
        startupModuleCombo.setMaxWidth(Double.POSITIVE_INFINITY);
        PreferenceAppearencePane.setFillWidth(startupModuleCombo, (Boolean)true);
        this.add((Node)startupModuleCombo, 1, 2);
        this.add((Node)HelpUtils.helpIcon(i18n.i18n("Set the module to open at application startup (restart needed)")), 2, 2);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.GRID.css());
    }
}

