/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.dashboard.preference.PreferenceAppearencePane;
import org.pdfsam.ui.dashboard.preference.PreferenceBehaviorPane;
import org.pdfsam.ui.dashboard.preference.PreferenceOutputPane;
import org.pdfsam.ui.dashboard.preference.PreferenceWorkspacePane;

@Named
public class PreferencePane
extends HBox {
    @Inject
    public PreferencePane(PreferenceAppearencePane appearence, PreferenceBehaviorPane behavior, PreferenceWorkspacePane workspace, PreferenceOutputPane output) {
        this.getStyleClass().add((Object)"dashboard-container");
        VBox left = new VBox(5.0);
        left.setMinWidth(Double.NEGATIVE_INFINITY);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Appearance"), (Pane)left);
        left.getChildren().add((Object)appearence);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Behavior"), (Pane)left);
        left.getChildren().add((Object)behavior);
        VBox right = new VBox(5.0);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Workspace"), (Pane)right);
        right.getChildren().add((Object)workspace);
        this.addSectionTitle(DefaultI18nContext.getInstance().i18n("Output"), (Pane)right);
        right.getChildren().add((Object)output);
        this.getChildren().addAll((Object[])new Node[]{left, right});
    }

    private void addSectionTitle(String title, Pane pane) {
        Label label = new Label(title);
        label.getStyleClass().add((Object)"section-title");
        pane.getChildren().add((Object)label);
    }
}

