/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.model.output.DirectoryTaskOutput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.output.StreamTaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;

class OpenButton
extends Button
implements TaskOutputDispatcher {
    private File destination;

    public OpenButton() {
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-footer-button", "pdfsam-footer-open-button"});
        this.setOnAction(e -> {
            if (this.destination != null && this.destination.exists()) {
                StaticStudio.eventStudio().broadcast(new OpenFileRequest(this.destination));
            }
        });
    }

    @Override
    public void dispatch(FileTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)GlyphsDude.createIcon(MaterialDesignIcon.FILE_PDF_BOX, "1.4em"));
        this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Open the generated document")));
    }

    @Override
    public void dispatch(DirectoryTaskOutput output) {
        this.destination = output.getDestination();
        this.setGraphic((Node)GlyphsDude.createIcon(MaterialDesignIcon.FOLDER_OUTLINE, "1.4em"));
        this.setTooltip(new Tooltip(DefaultI18nContext.getInstance().i18n("Open the destination directory")));
    }

    @Override
    public void dispatch(StreamTaskOutput output) {
        throw new IllegalArgumentException("Unsupported output type");
    }
}

