/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import de.jensd.fx.glyphs.GlyphsDude;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import javafx.scene.Node;

public enum NotificationType {
    INFO{

        @Override
        public Node getGraphic() {
            return GlyphsDude.createIcon(MaterialDesignIcon.INFORMATION, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-info";
        }
    }
    ,
    WARN{

        @Override
        public Node getGraphic() {
            return GlyphsDude.createIcon(MaterialDesignIcon.ALERT, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-warn";
        }
    }
    ,
    ERROR{

        @Override
        public Node getGraphic() {
            return GlyphsDude.createIcon(MaterialDesignIcon.CLOSE_CIRCLE, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-error";
        }
    }
    ,
    GO_PRO{

        @Override
        public Node getGraphic() {
            return GlyphsDude.createIcon(FontAwesomeIcon.HEART_ALT, NotificationType.DEFAULT_ICON_SIZE);
        }

        @Override
        public String getStyleClass() {
            return "notification-pro";
        }
    };

    private static final String DEFAULT_ICON_SIZE = "32.0";

    public abstract Node getGraphic();

    public abstract String getStyleClass();
}

